/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl.optel.config;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.runtime.metrics.exporter.config.impl.FileMeterExporterConfiguration;

public class OpenTelemetryAutoConfigurableMeterExporterConfiguration
implements MeterExporterConfiguration {
    @Inject
    private MuleContext muleContext;
    private static final String GRPC_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    private static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    private static final String DEFAULT_EXPORTER_INTERVAL = "60";
    private static final String DEFAULT_ENABLED_VALUE = "false";
    private MeterExporterConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();

    public OpenTelemetryAutoConfigurableMeterExporterConfiguration() {
    }

    public OpenTelemetryAutoConfigurableMeterExporterConfiguration(MeterExporterConfiguration delegate) {
        this.delegate = delegate;
        this.initialiseDefaultConfigurationValues();
    }

    public String getStringValue(String key) {
        try {
            if (this.delegate == null) {
                this.delegate = new FileMeterExporterConfiguration(this.muleContext);
                this.initialiseDefaultConfigurationValues();
            }
            return this.delegate.getStringValue(key, this.defaultConfigurationValues.get(key));
        }
        catch (PropertyNotFoundException e) {
            return this.defaultConfigurationValues.get(key);
        }
    }

    private void initialiseDefaultConfigurationValues() {
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.enabled", DEFAULT_ENABLED_VALUE);
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.type", "GRPC");
        if (this.getStringValue("mule.openTelemetry.meter.exporter.type").equals("GRPC")) {
            this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.openTelemetry.meter.exporter.interval", DEFAULT_EXPORTER_INTERVAL);
    }
}

