/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl;

import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.metrics.api.instrument.LongCounter;
import org.mule.runtime.metrics.api.instrument.LongUpDownCounter;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.exporter.impl.OpentelemetryExporterAttributes;
import org.mule.runtime.metrics.exporter.impl.config.OpenTelemetryMeterExporterTransport;
import org.mule.runtime.metrics.exporter.impl.optel.resources.MeterExporterConfiguratorException;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class OpenTelemetryMeterExporter
implements MeterExporter,
Disposable {
    private final List<ObservableLongCounter> counters = new ArrayList<ObservableLongCounter>();
    private final List<ObservableLongUpDownCounter> upDownCounters = new ArrayList<ObservableLongUpDownCounter>();
    private final Map<String, io.opentelemetry.api.metrics.Meter> openTelemetryMeters = new HashMap<String, io.opentelemetry.api.metrics.Meter>();
    private final MeterProvider meterProvider;
    private final PeriodicMetricReader periodicMetricReader;

    public OpenTelemetryMeterExporter(ObservabilitySignalConfiguration configuration, Resource resource) {
        MetricExporter metricExporter;
        String meterExporterType = configuration.getStringValue("mule.openTelemetry.meter.exporter.type");
        if (meterExporterType == null) {
            throw new MeterExporterConfiguratorException("A type for the metric export was not created");
        }
        try {
            metricExporter = OpenTelemetryMeterExporterTransport.valueOf(meterExporterType).getMeterExporterConfigurator().configExporter(configuration);
        }
        catch (Exception e) {
            throw new MeterExporterConfiguratorException(e);
        }
        long periodicMetricReaderInterval = Long.parseLong(configuration.getStringValue("mule.openTelemetry.meter.exporter.interval"));
        this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)metricExporter).setInterval(periodicMetricReaderInterval, TimeUnit.SECONDS).build();
        this.meterProvider = SdkMeterProvider.builder().setResource(resource).registerMetricReader((MetricReader)this.periodicMetricReader).build();
    }

    public synchronized void enableExport(LongCounter longCounter) {
        io.opentelemetry.api.metrics.Meter openTelemetryMeter = this.openTelemetryMeters.get(longCounter.getMeter().getName());
        OpentelemetryExporterAttributes attributes = new OpentelemetryExporterAttributes(longCounter.getMeter());
        LongCounterBuilder longCounterBuilder = openTelemetryMeter.counterBuilder(longCounter.getName()).setDescription(longCounter.getDescription());
        if (longCounter.getUnit() != null) {
            longCounterBuilder = longCounterBuilder.setUnit(longCounter.getUnit());
        }
        this.counters.add(longCounterBuilder.buildWithCallback(measurement -> measurement.record(longCounter.getValueAsLong(), attributes)));
    }

    public synchronized void enableExport(LongUpDownCounter upDownCounter) {
        io.opentelemetry.api.metrics.Meter openTelemetryMeter = this.openTelemetryMeters.get(upDownCounter.getMeter().getName());
        OpentelemetryExporterAttributes attributes = new OpentelemetryExporterAttributes(upDownCounter.getMeter());
        LongUpDownCounterBuilder longUpDownCounter = openTelemetryMeter.upDownCounterBuilder(upDownCounter.getName()).setDescription(upDownCounter.getDescription());
        if (upDownCounter.getUnit() != null) {
            longUpDownCounter = longUpDownCounter.setUnit(Objects.toString(upDownCounter.getUnit(), ""));
        }
        this.upDownCounters.add(longUpDownCounter.buildWithCallback(measurement -> measurement.record(upDownCounter.getValueAsLong(), attributes)));
    }

    public synchronized void registerMeterToExport(Meter meter) {
        this.openTelemetryMeters.put(meter.getName(), this.meterProvider.meterBuilder(meter.getName()).build());
    }

    public void dispose() {
        this.counters.forEach(ObservableLongCounter::close);
        this.upDownCounters.forEach(ObservableLongUpDownCounter::close);
        if (this.periodicMetricReader != null) {
            this.periodicMetricReader.shutdown();
        }
    }
}

