/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api.schema;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFetcher {
    private static Map<String, ContentFetcher> contentFetchers = new HashMap<String, ContentFetcher>();

    public List<XsdDependency> fetchAll(URL ... urls) {
        return new SchemaFetcherRequest().fetchAll(urls);
    }

    static {
        contentFetchers.put("http", new HTTPContentFetcher());
        contentFetchers.put("file", new FileContentFetcher());
    }

    private static class NoOpEntityResolver
    implements EntityResolver {
        private NoOpEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }

    private static class HTTPContentFetcher
    implements ContentFetcher {
        private static final String DELIMITER = "\\A";

        private HTTPContentFetcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<String> fetchContent(URL url) {
            try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
                Optional<String> optional = Optional.of(scanner.useDelimiter(DELIMITER).next());
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FileContentFetcher
    implements ContentFetcher {
        private static final String DELIMITER = "\\Z";

        private FileContentFetcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<String> fetchContent(URL url) {
            try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
                Optional<String> optional = Optional.of(scanner.useDelimiter(DELIMITER).next());
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface ContentFetcher {
        public Optional<String> fetchContent(URL var1);
    }

    private static class SchemaFetcherRequest {
        private Map<String, Schema> schemas = new HashMap<String, Schema>();

        private SchemaFetcherRequest() {
        }

        public List<XsdDependency> fetchAll(URL ... urls) {
            ArrayList<XsdDependency> dependencies = new ArrayList<XsdDependency>();
            for (URL url : urls) {
                Schema schema = new Schema(url);
                dependencies.addAll(schema.fetchDependencies());
            }
            return dependencies;
        }

        private class Schema {
            private static final String FILE = "file";
            private static final String HTTP = "http";
            private static final String CURRENT_DIRECTORY = ".";
            private static final String BACKWARD_DIRECTORY = "..";
            private static final String SCHEMA_LOCATION = "schemaLocation";
            private final URL url;
            private final Map<String, Schema> includesAndImports = new HashMap<String, Schema>();

            public Schema(URL url) {
                this.url = url;
            }

            public URL getUrl() {
                return this.url;
            }

            public List<XsdDependency> fetchDependencies() {
                Optional maybeContent;
                ArrayList<XsdDependency> dependencies = new ArrayList<XsdDependency>();
                ContentFetcher contentFetcher = (ContentFetcher)contentFetchers.get(this.url.getProtocol());
                Optional<Object> optional = maybeContent = contentFetcher != null ? contentFetcher.fetchContent(this.url) : Optional.empty();
                if (maybeContent.isPresent()) {
                    InputSource source = new InputSource(new StringReader((String)maybeContent.get()));
                    List<Node> includesAndImportsNodes = this.getXpathNodes(source, "/*[local-name()='schema']/*[local-name()='include' or local-name()='import']");
                    for (Node element : includesAndImportsNodes) {
                        String schemaLocation;
                        Optional<URL> maybeUrl;
                        Node schemaLocationAttribute = element.getAttributes().getNamedItem(SCHEMA_LOCATION);
                        if (schemaLocationAttribute == null || !(maybeUrl = this.buildUrl(this.url, schemaLocation = schemaLocationAttribute.getNodeValue())).isPresent()) continue;
                        URL dependency = maybeUrl.get();
                        Schema schema = new Schema(dependency);
                        this.includesAndImports.put(schemaLocation, schema);
                        dependencies.add(new XsdDependency(this.url, dependency));
                    }
                    SchemaFetcherRequest.this.schemas.put(this.url.toString(), this);
                    for (Schema schemaToIncludeOrImport : this.includesAndImports.values()) {
                        if (SchemaFetcherRequest.this.schemas.containsKey(schemaToIncludeOrImport.getUrl().toString())) continue;
                        dependencies.addAll(schemaToIncludeOrImport.fetchDependencies());
                    }
                }
                return dependencies;
            }

            /*
             * Exception decompiling
             */
            private List<Node> getXpathNodes(InputSource source, String path) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private Optional<URL> buildUrl(URL parent, String schemaLocation) {
                try {
                    if (schemaLocation.startsWith(HTTP) || schemaLocation.startsWith(FILE)) {
                        return Optional.of(new URL(schemaLocation));
                    }
                    URI parentUri = parent.toURI().getPath().endsWith("/") ? parent.toURI().resolve(BACKWARD_DIRECTORY) : parent.toURI().resolve(CURRENT_DIRECTORY);
                    URL url = new URL(parentUri.toURL().toString() + schemaLocation);
                    return Optional.of(new URL(url.toURI().normalize().toString()));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class XsdDependency {
        private final URL parent;
        private final URL dependency;

        public XsdDependency(URL parent, URL dependency) {
            this.parent = parent;
            this.dependency = dependency;
        }

        public URL getParent() {
            return this.parent;
        }

        public URL getDependency() {
            return this.dependency;
        }
    }
}

