/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.metadata.xml.internal.ResourceResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolverFactory {
    private static final String LOAD_EXTERNAL_RESOURCES = "mule.xml.loadExternalResources";

    private ResourceResolverFactory() {
    }

    public static LSResourceResolver create(Map<String, List<DOMInputImpl>> schemaByTargetNamespace) {
        LSResourceResolver resourceResolver = new ResourceResolver(schemaByTargetNamespace);
        if (!Boolean.valueOf(System.getProperty(LOAD_EXTERNAL_RESOURCES, "true")).booleanValue()) {
            resourceResolver = new ResourceResolverRequiredDecorator(resourceResolver);
        }
        return resourceResolver;
    }

    private static class ResourceResolverRequiredDecorator
    implements LSResourceResolver {
        LSResourceResolver resourceResolver;

        public ResourceResolverRequiredDecorator(LSResourceResolver resourceResolver) {
            this.resourceResolver = resourceResolver;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return Objects.requireNonNull(this.resourceResolver.resolveResource(type, namespaceURI, publicId, systemId, baseURI));
        }
    }
}

