/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.MetadataTypeConstants;
import org.mule.metadata.persistence.TypeAnnotationSerializer;
import org.mule.metadata.persistence.TypeAnnotationSerializerFactory;
import org.mule.metadata.persistence.serializer.TypeSerializer;

public abstract class BaseTypeSerializer<T extends MetadataType>
implements TypeSerializer<T> {
    protected final String typeName;
    private final TypeAnnotationSerializer typeAnnotationSerializer;

    BaseTypeSerializer(String typeName) {
        this.typeName = typeName;
        this.typeAnnotationSerializer = TypeAnnotationSerializerFactory.getInstance().getTypeAnnotationSerializer();
    }

    @Override
    public void serialize(JsonWriter writer, T type, Stack<MetadataType> typeStack) {
        try {
            writer.beginObject();
            this.writeMetadataFormat(writer, (MetadataType)type, typeStack);
            typeStack.push((MetadataType)type);
            this.writeType(writer, (MetadataType)type, this.typeName);
            this.doSerialize(writer, type, typeStack);
            writer.endObject();
            typeStack.pop();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(this.typeName + " MetadataType", e);
        }
    }

    protected abstract void doSerialize(JsonWriter var1, T var2, Stack<MetadataType> var3) throws IOException;

    protected void writeMetadataFormat(JsonWriter writer, MetadataType type, Stack<MetadataType> typeStack) throws IOException {
        MetadataFormat metadataFormat = type.getMetadataFormat();
        if (typeStack.isEmpty() || metadataFormat != typeStack.peek().getMetadataFormat()) {
            writer.name("format");
            if (MetadataTypeConstants.commonMetadataFormats.contains(metadataFormat)) {
                writer.value(metadataFormat.getId());
            } else {
                writer.beginObject();
                writer.name("id").value(metadataFormat.getId());
                if (metadataFormat.getLabel().isPresent()) {
                    writer.name("label").value((String)metadataFormat.getLabel().get());
                }
                writer.name("validMimeTypes");
                writer.beginArray();
                for (String s : metadataFormat.getValidMimeTypes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.endObject();
            }
        }
    }

    private void writeType(JsonWriter writer, MetadataType metadataType, String type) {
        try {
            writer.name("type").value(type);
            this.writeAnnotations(writer, metadataType.getAnnotations());
        }
        catch (IOException e) {
            throw new MetadataSerializingException(type, e);
        }
    }

    private String getAnnotationJsonName(TypeAnnotation annotation) {
        if (this.typeAnnotationSerializer.getNameClassMapping().containsKey(annotation.getName())) {
            return annotation.getName();
        }
        return annotation.getClass().getName();
    }

    protected void writeAnnotations(JsonWriter writer, Collection<TypeAnnotation> annotations) throws IOException {
        List publicAnnotations = annotations.stream().filter(TypeAnnotation::isPublic).collect(Collectors.toList());
        if (!publicAnnotations.isEmpty()) {
            writer.name("annotations");
            writer.beginObject();
            for (TypeAnnotation annotation : publicAnnotations) {
                writer.name(this.getAnnotationJsonName(annotation));
                this.typeAnnotationSerializer.serialize(writer, annotation);
            }
            writer.endObject();
        }
    }
}

