/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.reduced.ReferenceResolver;

public class InnerCatalogObjectTypeReferenceHandler
implements ObjectTypeReferenceHandler {
    private ReferenceResolver referenceResolver;
    private Map<String, MetadataType> catalog;

    InnerCatalogObjectTypeReferenceHandler(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    InnerCatalogObjectTypeReferenceHandler(Map<String, MetadataType> catalog) {
        this.catalog = catalog;
    }

    @Override
    public Optional<TypeBuilder> readReference(String typeReference) {
        if (typeReference.startsWith("@ref:")) {
            return Optional.of(() -> this.catalog.get(typeReference.replace("@ref:", "")));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
        Optional<String> referenceOptional = this.referenceResolver.getIdentifier(type);
        if (referenceOptional.isPresent()) {
            String reference = referenceOptional.get();
            try {
                writer.name("type").value("@ref:" + reference);
            }
            catch (IOException e) {
                throw new MetadataSerializingException("MetadataType reference [" + reference + "]", e);
            }
        }
        return referenceOptional;
    }
}

