/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataDeserializingException;
import org.mule.metadata.persistence.MetadataTypeWriter;
import org.mule.metadata.persistence.SerializedMetadataTypeLoader;

public abstract class BaseMetadataTypeGsonTypeAdapter
extends TypeAdapter<MetadataType> {
    private final MetadataTypeWriter jsonMetadataTypeWriter;
    private final SerializedMetadataTypeLoader jsonMetadataTypeLoader;

    public BaseMetadataTypeGsonTypeAdapter(MetadataTypeWriter writer, SerializedMetadataTypeLoader loader) {
        this.jsonMetadataTypeWriter = writer;
        this.jsonMetadataTypeLoader = loader;
    }

    public void write(JsonWriter jsonWriter, MetadataType metadataType) throws IOException {
        this.jsonMetadataTypeWriter.write(metadataType, jsonWriter);
    }

    public MetadataType read(JsonReader jsonReader) throws IOException {
        JsonElement jsonMetadataTypeElement = new JsonParser().parse(jsonReader);
        Optional<MetadataType> load = this.jsonMetadataTypeLoader.load(jsonMetadataTypeElement);
        if (load.isPresent()) {
            return load.get();
        }
        throw new MetadataDeserializingException("Unknown error happen deserializing the MetadataType object");
    }
}

