/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;

public final class MetadataTypeGsonTypeAdapter
extends TypeAdapter<MetadataType> {
    private final JsonMetadataTypeWriter jsonMetadataTypeWriter;
    private final JsonMetadataTypeLoader jsonMetadataTypeLoader;

    public MetadataTypeGsonTypeAdapter() {
        this(new NullObjectTypeReferenceHandler());
    }

    public MetadataTypeGsonTypeAdapter(ObjectTypeReferenceHandler referenceHandler) {
        this.jsonMetadataTypeWriter = new JsonMetadataTypeWriter(referenceHandler);
        this.jsonMetadataTypeLoader = new JsonMetadataTypeLoader(referenceHandler);
    }

    public void write(JsonWriter jsonWriter, MetadataType metadataType) throws IOException {
        this.jsonMetadataTypeWriter.write(metadataType, jsonWriter);
    }

    public MetadataType read(JsonReader jsonReader) throws IOException {
        JsonElement jsonMetadataTypeElement = new JsonParser().parse(jsonReader);
        Optional<MetadataType> load = this.jsonMetadataTypeLoader.load(jsonMetadataTypeElement);
        if (load.isPresent()) {
            return load.get();
        }
        throw new MetadataSerializingException("Unknown error happen deserializing the MetadataType object");
    }
}

