/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.FieldOccurrenceAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.annotation.UniquesItemsAnnotation;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.persistence.TypeAnnotationSerializer;
import org.mule.metadata.persistence.api.TypeAnnotationSerializerExtender;
import org.mule.metadata.persistence.api.TypeAnnotationSerializerExtenderFallback;

public final class TypeAnnotationSerializerFactory {
    private static TypeAnnotationSerializerFactory INSTANCE = new TypeAnnotationSerializerFactory();
    private final HashBiMap<String, Class<? extends TypeAnnotation>> stringClassHashMap = HashBiMap.create();
    private final Collection<Object> additionalFeatures = new LinkedList<Object>();
    private final TypeAnnotationSerializerExtenderFallback typeAnnotationSerializerExtenderFallback;

    public static TypeAnnotationSerializerFactory getInstance() {
        return INSTANCE;
    }

    private TypeAnnotationSerializerFactory() {
        this.stringClassHashMap.put((Object)"label", LabelAnnotation.class);
        this.stringClassHashMap.put((Object)"length", LengthAnnotation.class);
        this.stringClassHashMap.put((Object)"visibility", AccessibilityAnnotation.class);
        this.stringClassHashMap.put((Object)"default", DefaultValueAnnotation.class);
        this.stringClassHashMap.put((Object)"description", DescriptionAnnotation.class);
        this.stringClassHashMap.put((Object)"enum", EnumAnnotation.class);
        this.stringClassHashMap.put((Object)"example", ExampleAnnotation.class);
        this.stringClassHashMap.put((Object)"occurrence", FieldOccurrenceAnnotation.class);
        this.stringClassHashMap.put((Object)"int", IntAnnotation.class);
        this.stringClassHashMap.put((Object)"range", NumberRangeAnnotation.class);
        this.stringClassHashMap.put((Object)"pattern", RegexPatternAnnotation.class);
        this.stringClassHashMap.put((Object)"typeId", TypeIdAnnotation.class);
        this.stringClassHashMap.put((Object)"uniques", UniquesItemsAnnotation.class);
        this.stringClassHashMap.put((Object)"classInformation", ClassInformationAnnotation.class);
        this.stringClassHashMap.put((Object)"typeAlias", TypeAliasAnnotation.class);
        ServiceLoader<TypeAnnotationSerializerExtender> extenders = ServiceLoader.load(TypeAnnotationSerializerExtender.class);
        extenders.forEach(extender -> {
            this.stringClassHashMap.putAll(extender.getNameClassMapping());
            this.additionalFeatures.addAll(extender.getAdditionalFeatures());
        });
        Iterator<TypeAnnotationSerializerExtenderFallback> fallbackIterator = ServiceLoader.load(TypeAnnotationSerializerExtenderFallback.class).iterator();
        this.typeAnnotationSerializerExtenderFallback = fallbackIterator.hasNext() ? fallbackIterator.next() : null;
    }

    public TypeAnnotationSerializer getTypeAnnotationSerializer() {
        return new TypeAnnotationSerializer((Map<String, Class<? extends TypeAnnotation>>)this.stringClassHashMap, this.additionalFeatures, this.typeAnnotationSerializerExtenderFallback);
    }
}

