/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.deserializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.persistence.deserializer.AnyTypeDeserializer;
import org.mule.metadata.persistence.deserializer.ArrayTypeDeserializer;
import org.mule.metadata.persistence.deserializer.BinaryTypeDeserializer;
import org.mule.metadata.persistence.deserializer.BooleanTypeDeserializer;
import org.mule.metadata.persistence.deserializer.DateTimeTypeDeserializer;
import org.mule.metadata.persistence.deserializer.DateTypeDeserializer;
import org.mule.metadata.persistence.deserializer.IntersectionTypeDeserializer;
import org.mule.metadata.persistence.deserializer.NumberTypeDeserializer;
import org.mule.metadata.persistence.deserializer.ObjectTypeDeserializer;
import org.mule.metadata.persistence.deserializer.StringTypeDeserializer;
import org.mule.metadata.persistence.deserializer.TimeTypeDeserializer;
import org.mule.metadata.persistence.deserializer.TupleTypeDeserializer;
import org.mule.metadata.persistence.deserializer.TypeDeserializer;
import org.mule.metadata.persistence.deserializer.UnionTypeDeserializer;

public final class MetadataTypeDeserializerProvider {
    private final Map<String, TypeDeserializer> typeDeserializers = Collections.unmodifiableMap(new HashMap<String, TypeDeserializer>(){
        {
            this.put("Any", new AnyTypeDeserializer());
            this.put("Array", new ArrayTypeDeserializer());
            this.put("Boolean", new BooleanTypeDeserializer());
            this.put("Binary", new BinaryTypeDeserializer());
            this.put("Date", new DateTypeDeserializer());
            this.put("DateTime", new DateTimeTypeDeserializer());
            this.put("Intersection", new IntersectionTypeDeserializer());
            this.put("Object", new ObjectTypeDeserializer());
            this.put("Number", new NumberTypeDeserializer());
            this.put("String", new StringTypeDeserializer());
            this.put("Time", new TimeTypeDeserializer());
            this.put("Tuple", new TupleTypeDeserializer());
            this.put("Union", new UnionTypeDeserializer());
            this.put("Null", (typeObject, baseBuilder, typeLoader) -> baseBuilder.nullType());
            this.put("Void", (typeObject, baseBuilder, typeLoader) -> baseBuilder.voidType());
        }
    });

    public Optional<TypeDeserializer> get(String typeName) {
        return Optional.ofNullable(this.typeDeserializers.get(typeName));
    }
}

