/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.example;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.api.example.HandlerManager;
import org.mule.metadata.json.api.example.JsonElementHandler;
import org.mule.metadata.json.api.example.ParsingContext;

public class ObjectHandler
implements JsonElementHandler {
    @Override
    public boolean handles(JsonElement jsonElement) {
        return jsonElement.isJsonObject();
    }

    @Override
    public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        JsonObject object = (JsonObject)jsonElement;
        ObjectTypeBuilder objectTypeBuilder = root.objectType();
        parsingContext.getAnnotations().forEach(arg_0 -> ((ObjectTypeBuilder)objectTypeBuilder).with(arg_0));
        for (Map.Entry member : object.entrySet()) {
            ObjectFieldTypeBuilder field = objectTypeBuilder.addField();
            field.key((String)member.getKey());
            field.required(parsingContext.getHandlerConfiguration().isFieldRequirementDefault());
            JsonElement value = (JsonElement)member.getValue();
            field.value(handlerManager.handle(value, new ParsingContext(parsingContext.getHandlerConfiguration())));
        }
        return objectTypeBuilder;
    }
}

