/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.handler;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.Accessibility;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.api.utils.TypeResolver;

public class DefaultObjectFieldHandler
implements ObjectFieldHandler {
    @Override
    public void handleFields(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (!(Object.class.equals(clazz) || Void.class.equals(clazz) || Void.TYPE.equals(clazz))) {
            try {
                List<PropertyDescriptor> propertyDescriptors = this.loadProperties(clazz);
                for (PropertyDescriptor pd : propertyDescriptors) {
                    Type propertyType;
                    Optional<TypeBuilder<?>> typeBuilder;
                    Class<?> propertyClass = pd.getPropertyType();
                    if (propertyClass == null) continue;
                    ObjectFieldTypeBuilder fieldBuilder = builder.addField();
                    String name = pd.getName();
                    fieldBuilder.key(name);
                    Optional<Accessibility> visibility = this.getVisibility(pd);
                    if (visibility.isPresent()) {
                        fieldBuilder.accessibility(visibility.get());
                    }
                    if ((typeBuilder = context.getTypeBuilder(propertyType = this.getPropertyType(pd))).isPresent()) {
                        fieldBuilder.value(typeBuilder.get());
                        continue;
                    }
                    typeHandlerManager.handle(propertyType, context, fieldBuilder.value());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Optional<Accessibility> getVisibility(PropertyDescriptor pd) {
        if (pd.getReadMethod() != null && pd.getWriteMethod() == null) {
            return Optional.of(Accessibility.READ_ONLY);
        }
        if (pd.getReadMethod() == null && pd.getWriteMethod() != null) {
            return Optional.of(Accessibility.WRITE_ONLY);
        }
        return Optional.empty();
    }

    private Type getPropertyType(PropertyDescriptor pd) {
        Class<?> propertyType = pd.getReadMethod() != null ? pd.getReadMethod().getGenericReturnType() : pd.getWriteMethod().getParameterTypes()[0];
        return propertyType;
    }

    private List<PropertyDescriptor> loadProperties(Class<?> clazz) throws IntrospectionException {
        List<PropertyDescriptor> propertyDescriptors;
        if (clazz.isInterface()) {
            propertyDescriptors = new ArrayList<PropertyDescriptor>(Arrays.asList(Introspector.getBeanInfo(clazz).getPropertyDescriptors()));
            for (Class<?> interfaceType : TypeResolver.getSuperInterfaces(clazz)) {
                propertyDescriptors.addAll(Arrays.asList(Introspector.getBeanInfo(interfaceType).getPropertyDescriptors()));
            }
        } else {
            propertyDescriptors = Arrays.asList(Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors());
        }
        return propertyDescriptors.stream().filter(pd -> {
            if (pd.getReadMethod() != null) {
                return !pd.getReadMethod().getDeclaringClass().getName().startsWith("org.mule.runtime.api.component.");
            }
            if (pd.getWriteMethod() != null) {
                return !pd.getWriteMethod().getDeclaringClass().getName().startsWith("org.mule.runtime.api.component.");
            }
            return false;
        }).collect(Collectors.toList());
    }
}

