/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.annotation;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.java.api.utils.TypeResolver;

public class ClassInformationAnnotation
implements TypeAnnotation {
    public static final String INTERNAL_METADATA_PACKAGE = "org.mule.runtime.api.component.";
    public static final String NAME = "classInformation";
    private final String classname;
    private final boolean hasDefaultConstructor;
    private final boolean isInterface;
    private final boolean isInstantiable;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final List<String> implementedInterfaces;
    private final String parent;
    private final List<String> genericTypes;
    private final boolean isMap;

    public ClassInformationAnnotation(Class<?> clazz) {
        this(clazz, Collections.emptyList());
    }

    public ClassInformationAnnotation(Class<?> clazz, List<Type> genericTypes) {
        this.classname = clazz.getCanonicalName();
        this.implementedInterfaces = this.getImplementedInterfaces(clazz);
        this.parent = this.getParentClass(clazz);
        this.isFinal = Modifier.isFinal(clazz.getModifiers());
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
        this.isInterface = clazz.isInterface();
        this.hasDefaultConstructor = this.hasDefaultConstructor(clazz);
        this.genericTypes = this.getGenerics(genericTypes);
        this.isInstantiable = !this.isInterface && !this.isAbstract && this.hasDefaultConstructor;
        this.isMap = Map.class.isAssignableFrom(clazz);
    }

    private List<String> getGenerics(List<Type> genericTypes) {
        if (genericTypes != null && !genericTypes.isEmpty()) {
            return Collections.unmodifiableList(genericTypes.stream().map(TypeResolver::erase).map(Type::getTypeName).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private List<String> getImplementedInterfaces(Class<?> clazz) {
        return Collections.unmodifiableList(Arrays.stream(clazz.getInterfaces()).map(Class::getCanonicalName).filter(name -> name != null).filter(name -> !name.startsWith(INTERNAL_METADATA_PACKAGE)).collect(Collectors.toList()));
    }

    private String getParentClass(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        return parent != null && !parent.equals(Object.class) && !parent.getName().startsWith(INTERNAL_METADATA_PACKAGE) ? parent.getName() : "";
    }

    private boolean hasDefaultConstructor(Class<?> clazz) {
        return !this.isInterface && Arrays.stream(clazz.getDeclaredConstructors()).anyMatch(c -> c.getParameterCount() == 0 && Modifier.isPublic(c.getModifiers()));
    }

    public String getName() {
        return NAME;
    }

    public String getClassname() {
        return this.classname;
    }

    public boolean isInstantiable() {
        return this.isInstantiable;
    }

    public List<String> getGenericTypes() {
        return this.genericTypes;
    }

    public Optional<String> getParent() {
        return StringUtils.isNotBlank((CharSequence)this.parent) ? Optional.of(this.parent) : Optional.empty();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public List<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public boolean hasDefaultConstructor() {
        return this.hasDefaultConstructor;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }
}

