/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class MuleLazyValue<T>
implements Supplier<T> {
    private volatile boolean initialized = false;
    private T value;
    private Supplier<T> valueSupplier;

    public MuleLazyValue(Supplier<T> supplier) {
        MetadataTypeUtils.checkArgument((supplier != null ? 1 : 0) != 0, (String)"supplier cannot be null");
        this.valueSupplier = supplier;
    }

    public MuleLazyValue(T value) {
        this.value = value;
        this.initialized = true;
        this.valueSupplier = () -> value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            MuleLazyValue muleLazyValue = this;
            synchronized (muleLazyValue) {
                if (!this.initialized) {
                    this.value = this.valueSupplier.get();
                    this.valueSupplier = () -> this.value;
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    public boolean isComputed() {
        return this.initialized;
    }

    public void ifComputed(Consumer<T> consumer) {
        if (this.initialized) {
            consumer.accept(this.value);
        }
    }

    public <R> R flatMap(Function<T, R> function) {
        return function.apply(this.get());
    }
}

