/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.api;

import static java.util.Locale.ENGLISH;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

/**
 * Object representing a Java Bean Property
 *
 * @since 1.1
 */
public final class Property {

  private ExecutableElement getterMethod;
  private ExecutableElement setterMethod;
  private String name;
  private String beanName;

  public ExecutableElement getGetterMethod() {
    return getterMethod;
  }

  public void setGetterMethod(ExecutableElement getterMethod) {
    this.getterMethod = getterMethod;
  }

  public ExecutableElement getSetterMethod() {
    return setterMethod;
  }

  public void setSetterMethod(ExecutableElement setterMethod) {
    this.setterMethod = setterMethod;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
    this.beanName = normalize(name);
  }

  public String getBeanName() {
    return beanName;
  }

  public TypeMirror getType() {
    if (getterMethod != null) {
      return getterMethod.getReturnType();
    } else {
      return setterMethod.getReturnType();
    }
  }

  public static String normalize(String name) {
    if (name == null || name.length() == 0) {
      return name;
    }
    return name.substring(0, 1).toLowerCase(ENGLISH) + name.substring(1);
  }
}
