/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.internal.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Scanner;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.builder.TypeLoaderRegistry;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class TypesResolverBuilder {
    public static final String JAR = "jar";
    private final URI baseUri;
    private String catalogName;
    private String catalogFormat;
    private String schemaFormat;
    private String schemaLocation;
    private String schemaContent;
    private String exampleFormat;
    private String exampleLocation;
    private String exampleContent;

    public TypesResolverBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void catalogName(String name) {
        this.catalogName = name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void catalogFormat(String format) {
        this.catalogFormat = format;
    }

    public void schemaFormat(String schemaFormat) {
        this.schemaFormat = schemaFormat;
    }

    public void schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void schemaContent(String schemaContent) {
        this.schemaContent = schemaContent;
    }

    public void exampleFormat(String exampleFormat) {
        this.exampleFormat = exampleFormat;
    }

    public void exampleLocation(String exampleLocation) {
        this.exampleLocation = exampleLocation;
    }

    public void exampleContent(String exampleContent) {
        this.exampleContent = exampleContent;
    }

    TypeLoader build(TypeLoaderRegistry shapesRegistry, TypeLoaderRegistry examplesRegistry) throws Exception {
        TypeLoader typeLoader;
        if (this.catalogName == null || this.catalogName.isEmpty()) {
            throw new RuntimeException("Catalog must have a non empty 'name' attribute");
        }
        if (this.schemaFormat != null) {
            typeLoader = this.schemaLocation != null ? this.createFromUrl(shapesRegistry, this.catalogFormat, this.schemaFormat, this.resolveURI(this.schemaLocation)) : this.createFromContent(shapesRegistry, this.catalogFormat, this.schemaFormat, this.schemaContent);
        } else if (this.exampleFormat != null) {
            if (this.exampleLocation != null) {
                URI exampleURI = this.resolveURI(this.exampleLocation);
                typeLoader = this.createFromUrl(examplesRegistry, this.catalogFormat, this.exampleFormat, exampleURI);
            } else {
                typeLoader = this.createFromContent(examplesRegistry, this.catalogFormat, this.exampleFormat, this.exampleContent);
            }
        } else {
            throw new RuntimeException(String.format("Catalog '%s' must have either <schema> or <example> to read from.", this.catalogName));
        }
        return typeLoader;
    }

    private static TypeLoaderFactory getTypeLoaderFactory(TypeLoaderRegistry registry, String typeFormat, String shapeFormat) {
        TypeLoaderFactory typeLoaderFactory = registry.getFactory(typeFormat, shapeFormat).orElseThrow(() -> new RuntimeException(String.format("Unsupported typeFormat %s shapeFormat %s", typeFormat, shapeFormat)));
        return typeLoaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeLoader createFromUrl(TypeLoaderRegistry registry, String typeFormat, String shapeFormat, URI schemaUri) throws IOException {
        InputStream inputStream;
        if (schemaUri.getScheme().equals(JAR)) {
            JarURLConnection jarConnection = new JarURLConnection(schemaUri.toURL(), new Handler());
            ((URLConnection)jarConnection).setUseCaches(false);
            inputStream = ((URLConnection)jarConnection).getInputStream();
        } else {
            inputStream = schemaUri.toURL().openStream();
        }
        try {
            Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
            String content = scanner.hasNext() ? scanner.next() : "";
            TypeLoader typeLoader = TypesResolverBuilder.getTypeLoaderFactory(registry, typeFormat, shapeFormat).createTypeLoader(content, schemaUri);
            return typeLoader;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private TypeLoader createFromContent(TypeLoaderRegistry registry, String typeFormat, String shapeFormat, String content) {
        return TypesResolverBuilder.getTypeLoaderFactory(registry, typeFormat, shapeFormat).createTypeLoader(content);
    }

    private URI resolveURI(String location) throws URISyntaxException {
        return this.baseUri != null ? this.customResolve(location) : new URI(location);
    }

    private URI customResolve(String location) {
        URI result;
        if (this.baseUri.getScheme().equals(JAR)) {
            try {
                URI fileCatalogBase = new URI(this.baseUri.getRawSchemeSpecificPart());
                URI resolvedScheme = fileCatalogBase.resolve(location);
                result = new URI("jar:" + resolvedScheme);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(String.format("Cannot generate a relative URI for the resource [%s] given the base URI path [%s]", location, this.baseUri.toString()), e);
            }
        } else {
            result = this.baseUri.resolve(location);
        }
        return result;
    }
}

