/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.internal.utils;

import static java.lang.System.identityHashCode;

final class IDKey {

  private final Object value;
  private final int id;

  IDKey(final Object _value) {
    id = identityHashCode(_value);
    value = _value;
  }

  @Override
  public int hashCode() {
    return id;
  }

  @Override
  public boolean equals(final Object other) {
    if (!(other instanceof IDKey)) {
      return false;
    }
    final IDKey idKey = (IDKey) other;
    if (id != idKey.id) {
      return false;
    }
    return value == idKey.value;
  }
}
