/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static org.apache.commons.lang3.ArrayUtils.addAll;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.lang.reflect.Field;
import java.util.Map;

public class DefaultObjectFieldType extends BaseMetadataType implements ObjectFieldType {

  private final ObjectKeyType key;
  private final MetadataType value;
  private final boolean isRequired;
  private final boolean isRepeated;

  public DefaultObjectFieldType(ObjectKeyType key, MetadataType value, boolean isRequired, boolean isRepeated,
                                MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.key = key;
    this.value = value;
    this.isRequired = isRequired;
    this.isRepeated = isRepeated;
  }

  private static final Field[] REFLECTION_FIELDS;
  static {
    try {
      REFLECTION_FIELDS = addAll(BASE_REFLECTION_FIELDS,
                                 DefaultObjectFieldType.class.getDeclaredField("key"),
                                 DefaultObjectFieldType.class.getDeclaredField("value"),
                                 DefaultObjectFieldType.class.getDeclaredField("isRepeated"),
                                 DefaultObjectFieldType.class.getDeclaredField("isRequired"));
    } catch (NoSuchFieldException e) {
      throw new RuntimeException("Could not resolve field", e);
    }
  }

  @Override
  public Field[] getReflectionComparableFields() {
    return REFLECTION_FIELDS;
  }

  @Override
  public ObjectKeyType getKey() {
    return key;
  }

  @Override
  public MetadataType getValue() {
    return value;
  }

  @Override
  public boolean isRequired() {
    return isRequired;
  }

  @Override
  public boolean isRepeated() {
    return isRepeated;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitObjectField(this);
  }
}
