/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;

public class LocalTimeTypeBuilder extends AbstractBuilder<LocalTimeType>
    implements TypeBuilder<LocalTimeType>, WithAnnotation<LocalTimeTypeBuilder> {

  protected LocalTimeTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public LocalTimeTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public LocalTimeTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public LocalTimeTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  @Override
  public LocalTimeType build() {
    return new DefaultLocalTimeType(format, annotations);
  }


}
