/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import javax.xml.namespace.QName;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

/**
 * Represents an object key. It contains the name or pattern and the attributes.
 */
public interface ObjectKeyType extends MetadataType {

  /**
   * The name of the key if it is a named key else throws a NoSuchElementException.
   *
   * @throws NoSuchElementException if it is not a named key.
   * @return The name of the key.
   */
  QName getName();

  /**
   * Return if the this is a named key or not
   * 
   * @return <code>True</code> if it is a named key
   */
  boolean isName();

  /**
   * The pattern of the key if it is a pattern based key else throws a NoSuchElementException.
   *
   * @throws NoSuchElementException if it is not a pattern based key.
   * @return The name of the key.
   */
  Pattern getPattern();

  /**
   * Return if the this is a pattern key or not.
   * 
   * @return <code>True</code> if it is a pattern key
   */
  boolean isPattern();

  /**
   * All the attributes of this key
   *
   * @return The collection with the attributes
   */
  Collection<AttributeFieldType> getAttributes();
}
