/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.util.ExtensionErrorUtils;

public class ValidatorModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operation) {
                if (!operation.getStereotype().isAssignableTo(MuleStereotypes.VALIDATOR)) {
                    return;
                }
                if (!(operation.getOutput().getType() instanceof VoidType)) {
                    problemsReporter.addError(new Problem((NamedObject)operation, String.format("Operation '%s' is marked as a validator but it's not void.", operation.getName())));
                }
                if (!ExtensionErrorUtils.getValidationError(operation.getErrorModels()).isPresent()) {
                    problemsReporter.addError(new Problem((NamedObject)operation, String.format("Operation '%s' is a validator but it doesn't declare a validation error. Upon failure, all validators must throw a Mule validation error or a child of one", operation.getName())));
                }
            }
        }.walk(model);
    }
}

