/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.internal.property.NoTransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalTypeModelProperty;
import org.mule.sdk.api.tx.SourceTransactionalAction;

public final class TransactionalDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private final MetadataType operationTransactionalActionType;
        private final MetadataType sourceTransactionalActionType;
        private final MetadataType sdkOperationTransactionalActionType;
        private final MetadataType sdkSourceTransactionalActionType;
        private final MetadataType transactionType;

        private EnricherDelegate() {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            this.operationTransactionalActionType = typeLoader.load(OperationTransactionalAction.class);
            this.sourceTransactionalActionType = typeLoader.load(org.mule.runtime.extension.api.tx.SourceTransactionalAction.class);
            this.sdkOperationTransactionalActionType = typeLoader.load(org.mule.sdk.api.tx.OperationTransactionalAction.class);
            this.sdkSourceTransactionalActionType = typeLoader.load(SourceTransactionalAction.class);
            this.transactionType = typeLoader.load(TransactionType.class);
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            new IdempotentDeclarationWalker(){

                @Override
                protected void onSource(SourceDeclaration declaration) {
                    EnricherDelegate.this.addTxParameter("transactionalAction", EnricherDelegate.this.sourceTransactionalActionType, EnricherDelegate.this.sdkSourceTransactionalActionType, (Object)org.mule.runtime.extension.api.tx.SourceTransactionalAction.NONE, SourceTransactionalAction.NONE, "The type of beginning action that sources can take regarding transactions.", (ExecutableComponentDeclaration)declaration, new TransactionalActionModelProperty());
                    EnricherDelegate.this.addTxParameter("transactionType", null, EnricherDelegate.this.transactionType, null, TransactionType.LOCAL, "The type of transaction to create. Availability will depend on the runtime version.", (ExecutableComponentDeclaration)declaration, new TransactionalTypeModelProperty());
                }

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    EnricherDelegate.this.addTxParameter("transactionalAction", EnricherDelegate.this.operationTransactionalActionType, EnricherDelegate.this.sdkOperationTransactionalActionType, (Object)OperationTransactionalAction.JOIN_IF_POSSIBLE, org.mule.sdk.api.tx.OperationTransactionalAction.JOIN_IF_POSSIBLE, "The type of joining action that operations can take regarding transactions.", (ExecutableComponentDeclaration)declaration, new TransactionalActionModelProperty());
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }

        private void addTxParameter(String parameterName, MetadataType metadataType, MetadataType sdkMetadataType, Object defaultValue, Object sdkDefaultValue, String description, ExecutableComponentDeclaration<?> declaration, ModelProperty modelProperty) {
            if (!declaration.isTransactional() || declaration.getModelProperty(NoTransactionalActionModelProperty.class).isPresent()) {
                return;
            }
            Optional<ParameterDeclaration> parameterDeclaration = this.isPresent((ComponentDeclaration<?>)declaration, metadataType);
            Optional<ParameterDeclaration> sdkParameterDeclaration = this.isPresent((ComponentDeclaration<?>)declaration, sdkMetadataType);
            if (parameterDeclaration.isPresent() && sdkParameterDeclaration.isPresent()) {
                throw new IllegalModelDefinitionException(String.format("Component '%s' has transactional parameters from different APIs. Offending parameters are '%s' and '%s'.", declaration.getName(), parameterDeclaration.get().getName(), sdkParameterDeclaration.get().getName()));
            }
            if (parameterDeclaration.isPresent()) {
                this.enrichTransactionParameter(defaultValue, description, parameterDeclaration.get(), modelProperty);
            } else if (sdkParameterDeclaration.isPresent()) {
                this.enrichTransactionParameter(sdkDefaultValue, description, sdkParameterDeclaration.get(), modelProperty);
            } else {
                ParameterDeclaration transactionParameter = new ParameterDeclaration(parameterName);
                transactionParameter.setType(sdkMetadataType, false);
                this.enrichTransactionParameter(sdkDefaultValue, description, transactionParameter, modelProperty);
                declaration.getParameterGroup("General").addParameter(transactionParameter);
            }
        }

        private void enrichTransactionParameter(Object defaultValue, String description, ParameterDeclaration transactionParameter, ModelProperty modelProperty) {
            transactionParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            transactionParameter.setRequired(false);
            transactionParameter.setDefaultValue(defaultValue);
            transactionParameter.setDescription(description);
            transactionParameter.addModelProperty(modelProperty);
            transactionParameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        }

        private Optional<ParameterDeclaration> isPresent(ComponentDeclaration<?> declaration, MetadataType metadataType) {
            if (metadataType == null) {
                return Optional.empty();
            }
            return declaration.getParameterGroups().stream().flatMap(group -> group.getParameters().stream()).filter(parameterDeclaration -> parameterDeclaration.getType().equals(metadataType)).findAny();
        }
    }
}

