/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.component.value;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.component.value.ArrayValueDeclarer;
import org.mule.runtime.extension.api.component.value.ObjectValueDeclarer;
import org.mule.runtime.extension.api.component.value.ValueDeclarer;

public class DefaultValueDeclarer
implements ValueDeclarer {
    private HasValue value;

    @Override
    public void objectValue(Consumer<ObjectValueDeclarer> objectValueDeclarerConsumer) {
        this.value = new DefaultObjectValueDeclarer();
        objectValueDeclarerConsumer.accept((ObjectValueDeclarer)((Object)this.value));
    }

    @Override
    public void arrayValue(Consumer<ArrayValueDeclarer> arrayValueDeclarerConsumer) {
        this.value = new DefaultArrayValueDeclarer();
        arrayValueDeclarerConsumer.accept((ArrayValueDeclarer)((Object)this.value));
    }

    @Override
    public void withValue(Object value) {
        this.value = new SimpleHasValue(value);
    }

    public Object getValue() {
        return this.value.getValue();
    }

    private static Object getValue(Consumer<ValueDeclarer> valueDeclarerConsumer) {
        DefaultValueDeclarer valueDeclarer = new DefaultValueDeclarer();
        valueDeclarerConsumer.accept(valueDeclarer);
        return valueDeclarer.getValue();
    }

    private static class SimpleHasValue
    implements HasValue {
        private final Object value;

        public SimpleHasValue(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class DefaultArrayValueDeclarer
    implements ArrayValueDeclarer,
    HasValue {
        private final List<Object> listValue = new ArrayList<Object>();

        @Override
        public ArrayValueDeclarer withItem(Object value) {
            this.listValue.add(value);
            return this;
        }

        @Override
        public ArrayValueDeclarer withItem(Consumer<ValueDeclarer> valueDeclarerConsumer) {
            this.listValue.add(DefaultValueDeclarer.getValue(valueDeclarerConsumer));
            return this;
        }

        @Override
        public Object getValue() {
            return this.listValue;
        }
    }

    private static class DefaultObjectValueDeclarer
    implements ObjectValueDeclarer,
    HasValue {
        private final Map<String, Object> mapValue = new LinkedHashMap<String, Object>();

        @Override
        public ObjectValueDeclarer withField(String name, Object value) {
            this.mapValue.put(name, value);
            return this;
        }

        @Override
        public ObjectValueDeclarer withField(String name, Consumer<ValueDeclarer> valueDeclarerConsumer) {
            this.mapValue.put(name, DefaultValueDeclarer.getValue(valueDeclarerConsumer));
            return this;
        }

        @Override
        public Object getValue() {
            return this.mapValue;
        }
    }

    private static interface HasValue {
        public Object getValue();
    }
}

