/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.component.ComponentParameterization;

public class ComponentParameterizationBuilder<M extends ParameterizedModel>
implements ComponentParameterization.Builder<M> {
    private M model;
    private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters = new HashMap<Pair<ParameterGroupModel, ParameterModel>, Object>();

    public ComponentParameterization.Builder<M> withModel(M model) {
        this.model = model;
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String paramGroupName, String paramName, Object paramValue) throws IllegalArgumentException {
        ParameterGroupModel paramGroup = this.model.getParameterGroupModels().stream().filter(pgm -> pgm.getName().equals(paramGroupName)).findAny().orElseThrow(() -> new IllegalArgumentException("ParameterGroup does not exist: " + paramGroupName));
        ParameterModel parameter = (ParameterModel)paramGroup.getParameter(paramName).orElseThrow(() -> new IllegalArgumentException("Parameter does not exist in group '" + paramGroupName + "': " + paramName));
        this.parameters.put((Pair<ParameterGroupModel, ParameterModel>)new Pair((Object)paramGroup, (Object)parameter), paramValue);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String paramName, Object paramValue) throws IllegalArgumentException {
        List paramGroupsWithParamNamed = this.model.getParameterGroupModels().stream().filter(pgm -> pgm.getParameter(paramName).isPresent()).collect(Collectors.toList());
        if (paramGroupsWithParamNamed.isEmpty()) {
            throw new IllegalArgumentException("Parameter does not exist in any group: " + paramName);
        }
        if (paramGroupsWithParamNamed.size() > 1) {
            throw new IllegalArgumentException("Parameter exists in more than one group (" + paramGroupsWithParamNamed.stream().map(pgm -> pgm.getName()).collect(Collectors.toList()) + "): " + paramName);
        }
        ParameterGroupModel paramGroup = (ParameterGroupModel)paramGroupsWithParamNamed.get(0);
        this.parameters.put((Pair<ParameterGroupModel, ParameterModel>)new Pair((Object)paramGroup, ((ParameterGroupModel)paramGroupsWithParamNamed.get(0)).getParameter(paramName).get()), paramValue);
        return this;
    }

    @Override
    public ComponentParameterization<M> build() {
        return new DefaultComponentParameterization<M>(this.model, Collections.unmodifiableMap(this.parameters));
    }

    private static class DefaultComponentParameterization<M extends ParameterizedModel>
    implements ComponentParameterization<M> {
        private final M model;
        private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters;
        private final Map<Pair<String, String>, Object> parametersByNames;

        public DefaultComponentParameterization(M model, Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters) {
            this.model = model;
            this.parameters = parameters;
            this.parametersByNames = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(e -> new Pair((Object)((ParameterGroupModel)((Pair)e.getKey()).getFirst()).getName(), (Object)((ParameterModel)((Pair)e.getKey()).getSecond()).getName()), UnaryOperator.identity())));
        }

        @Override
        public M getModel() {
            return this.model;
        }

        @Override
        public Object getParameter(String paramGroupName, String paramName) {
            return this.parametersByNames.get(new Pair((Object)paramGroupName, (Object)paramName));
        }

        @Override
        public Object getParameter(ParameterGroupModel paramGroup, ParameterModel param) {
            return this.parameters.get(new Pair((Object)paramGroup, (Object)param));
        }

        @Override
        public Map<Pair<ParameterGroupModel, ParameterModel>, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public void forEachParameter(ComponentParameterization.ParameterAction action) {
            this.parameters.entrySet().forEach(e -> action.accept((ParameterGroupModel)((Pair)e.getKey()).getFirst(), (ParameterModel)((Pair)e.getKey()).getSecond(), e.getValue()));
        }
    }
}

