/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.parameter.AbstractStereotypedModel;

public abstract class AbstractComponentModel
extends AbstractStereotypedModel
implements ComponentModel {
    private List<? extends NestableElementModel> nestedComponents;
    private Set<ErrorModel> errors;
    private Set<String> semanticTerms;

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, nestedComponents, displayModel, errors, stereotype, modelProperties, null);
    }

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, nestedComponents, displayModel, errors, stereotype, modelProperties, deprecationModel, null);
    }

    protected AbstractComponentModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> nestedComponents, DisplayModel displayModel, Set<ErrorModel> errors, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms) {
        super(name, description, parameterGroupModels, displayModel, stereotype, modelProperties, deprecationModel);
        this.nestedComponents = this.copy(nestedComponents);
        this.errors = ImmutableSet.copyOf(errors);
        this.semanticTerms = semanticTerms != null ? Collections.unmodifiableSet(semanticTerms) : Collections.emptySet();
    }

    public Set<ErrorModel> getErrorModels() {
        if (this.errors == null) {
            this.errors = Collections.emptySet();
        }
        return this.errors;
    }

    public List<? extends NestableElementModel> getNestedComponents() {
        if (this.nestedComponents == null) {
            this.nestedComponents = Collections.emptyList();
        }
        return this.nestedComponents;
    }

    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return this.semanticTerms;
    }
}

