/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.time.Time;
import org.mule.runtime.api.util.DataUnit;

public final class ExtensionConstants {
    public static final String TARGET_PARAMETER_NAME = "target";
    public static final String TARGET_PARAMETER_DESCRIPTION = "The name of a variable on which the operation's output will be placed";
    public static final String TARGET_PARAMETER_DISPLAY_NAME = "Target Variable";
    public static final String TARGET_VALUE_PARAMETER_NAME = "targetValue";
    public static final String TARGET_VALUE_PARAMETER_DESCRIPTION = "An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable";
    public static final String TARGET_VALUE_PARAMETER_DISPLAY_NAME = "Target Value";
    public static final String STREAMING_STRATEGY_PARAMETER_NAME = "streamingStrategy";
    public static final String STREAMING_STRATEGY_PARAMETER_DESCRIPTION = "Configure if repeatable streams should be used and their behaviour";
    public static final String RECONNECTION_CONFIG_PARAMETER_NAME = "reconnection";
    public static final String RECONNECTION_CONFIG_PARAMETER_DESCRIPTION = "When the application is deployed, a connectivity test is performed on all connectors. If set to true, deployment will fail if the test doesn't pass after exhausting the associated reconnection strategy";
    public static final String RECONNECTION_STRATEGY_PARAMETER_NAME = "reconnectionStrategy";
    public static final String EXPIRATION_POLICY_PARAMETER_NAME = "expirationPolicy";
    public static final String EXPIRATION_POLICY_DESCRIPTION = "Configures the minimum amount of time that a dynamic configuration instance can remain idle before the runtime considers it eligible for expiration. This does not mean that the platform will expire the instance at the exact moment that it becomes eligible. The runtime will actually purge the instances when it sees it fit.";
    public static final String DYNAMIC_CONFIG_EXPIRATION_DESCRIPTION = "Configuration about how should the runtime handle the expiration of dynamic configurations";
    public static final String RECONNECTION_STRATEGY_PARAMETER_DESCRIPTION = "A retry strategy in case of connectivity errors";
    public static final String REDELIVERY_POLICY_PARAMETER_NAME = "redeliveryPolicy";
    public static final String REDELIVERY_POLICY_PARAMETER_DESCRIPTION = "Defines a policy for processing the redelivery of the same message";
    public static final String REDELIVERY_TAB_NAME = "Redelivery";
    public static final String TLS_PARAMETER_NAME = "tlsContext";
    public static final String SCHEDULING_STRATEGY_PARAMETER_NAME = "schedulingStrategy";
    public static final String SCHEDULING_STRATEGY_PARAMETER_DESCRIPTION = "Configures the scheduler that triggers the polling";
    public static final String ERROR_MAPPINGS_PARAMETER_NAME = "errorMappings";
    public static final String ERROR_MAPPINGS_PARAMETER_DESCRIPTION = "Set of error mappings";
    public static final String ERROR_MAPPING_DESCRIPTION = "Determines that an error thrown by this operation should be mapped to another";
    public static final String TRANSACTIONAL_ACTION_PARAMETER_NAME = "transactionalAction";
    public static final String TRANSACTIONAL_TYPE_PARAMETER_NAME = "transactionType";
    public static final String BACK_PRESSURE_STRATEGY_PARAMETER_NAME = "onCapacityOverload";
    public static final String BACK_PRESSURE_STRATEGY_PARAMETER_DESCRIPTION = "Strategy that the runtime will apply when the flow receives more messages than it has the capacity to handle";
    public static final int DEFAULT_BYTE_STREAMING_BUFFER_SIZE = 512;
    public static final int DEFAULT_BYTE_STREAMING_BUFFER_INCREMENT_SIZE = 512;
    public static final int DEFAULT_BYTES_STREAMING_MAX_BUFFER_SIZE = 1024;
    public static final DataUnit DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT = DataUnit.KB;
    public static final int DEFAULT_OBJECT_STREAMING_BUFFER_SIZE = 100;
    public static final int DEFAULT_OBJECT_STREAMING_BUFFER_INCREMENT_SIZE = 100;
    public static final int DEFAULT_OBJECT_STREAMING_MAX_BUFFER_SIZE = 500;
    public static final String OPERATION_TRANSACTIONAL_ACTION_PARAMETER_DESCRIPTION = "The type of joining action that operations can take regarding transactions.";
    public static final String SOURCE_TRANSACTIONAL_ACTION_PARAMETER_DESCRIPTION = "The type of beginning action that sources can take regarding transactions.";
    public static final String PRIMARY_NODE_ONLY_PARAMETER_NAME = "primaryNodeOnly";
    public static final String PRIMARY_NODE_ONLY_PARAMETER_DESCRIPTION = "Whether this source should only be executed on the primary node when runnning in Cluster";
    public static final String TRANSACTION_TYPE_PARAMETER_DESCRIPTION = "The type of transaction to create. Availability will depend on the runtime version.";
    public static final String POOLING_PROFILE_PARAMETER_NAME = "poolingProfile";
    public static final String POOLING_PROFILE_PARAMETER_DESCRIPTION = "Characteristics of the connection pool";
    public static final Time DYNAMIC_CONFIG_EXPIRATION_FREQUENCY = new Time(5L, TimeUnit.MINUTES);
    public static final String NAME_PARAM_DESCRIPTION = "The identifier of this element used to reference it in other components";
    public static final List<String> INFRASTRUCTURE_PARAMETER_NAMES = Arrays.asList("tlsContext", "poolingProfile", "reconnectionStrategy", "redeliveryPolicy", "target", "streamingStrategy", "transactionalAction", "schedulingStrategy");
    public static final String OBJECT_STORE_ELEMENT_NAMESPACE = "os";
    public static final String POLLING_SOURCE_LIMIT_PARAMETER_NAME = "maxItemsPerPoll";
    public static final String POLLING_SOURCE_LIMIT_PARAMETER_DESCRIPTION = "Limits the amount of items per poll. ";

    private ExtensionConstants() {
    }
}

