/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.operation;

import java.util.Optional;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;

public class Result<T, A> {
    private T output;
    private A attributes = null;
    private MediaType mediaType = null;
    private MediaType attributesMediaType = null;
    private long length;

    public static <T, A> Builder<T, A> builder() {
        return new Builder();
    }

    public static <T, A> Builder<T, A> builder(Message muleMessage) {
        return new Builder().output(muleMessage.getPayload().getValue()).attributes(muleMessage.getAttributes().getValue()).mediaType(muleMessage.getPayload().getDataType().getMediaType()).attributesMediaType(muleMessage.getAttributes().getDataType().getMediaType());
    }

    public static <T, A> Builder<T, A> builder(Result<T, A> prototypeResult) {
        Builder builder = new Builder().output(prototypeResult.getOutput());
        prototypeResult.getAttributes().ifPresent(builder::attributes);
        prototypeResult.getMediaType().ifPresent(builder::mediaType);
        prototypeResult.getAttributesMediaType().ifPresent(builder::attributesMediaType);
        return builder;
    }

    private Result() {
    }

    public T getOutput() {
        return this.output;
    }

    public Optional<A> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    public Optional<MediaType> getMediaType() {
        return Optional.ofNullable(this.mediaType);
    }

    public Optional<Long> getLength() {
        return this.length >= 0L ? Optional.of(this.length) : Optional.empty();
    }

    public Optional<MediaType> getAttributesMediaType() {
        return Optional.ofNullable(this.attributesMediaType);
    }

    public static final class Builder<T, A> {
        private final Result<T, A> product = new Result();

        private Builder() {
        }

        public Builder<T, A> output(T output) {
            ((Result)this.product).output = output;
            return this;
        }

        public Builder<T, A> attributes(A attributes) {
            ((Result)this.product).attributes = attributes;
            return this;
        }

        public Builder<T, A> mediaType(MediaType mediaType) {
            ((Result)this.product).mediaType = mediaType;
            return this;
        }

        public Builder<T, A> attributesMediaType(MediaType mediaType) {
            ((Result)this.product).attributesMediaType = mediaType;
            return this;
        }

        public Builder<T, A> length(long length) {
            ((Result)this.product).length = length;
            return this;
        }

        public Result<T, A> build() {
            return this.product;
        }
    }
}

