/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;

public class LegacyNestedElementModelTypeAdapter
extends TypeAdapter<NestableElementModel> {
    private static final String MIN_OCCURS_KEY = "minOccurs";
    private static final String MAX_OCCURS_KEY = "maxOccurs";
    private final TypeAdapter<NestableElementModel> delegate;

    public LegacyNestedElementModelTypeAdapter(TypeAdapter<NestableElementModel> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, NestableElementModel value) throws IOException {
        this.delegate.write(out, (Object)value);
    }

    public NestableElementModel read(JsonReader in) throws IOException {
        JsonObject element = new JsonParser().parse(in).getAsJsonObject();
        this.assureOccurrences(element);
        return (NestableElementModel)this.delegate.fromJsonTree((JsonElement)element);
    }

    private void assureOccurrences(JsonObject element) {
        JsonElement maxOccurs;
        boolean isRequired = this.isRequired(element);
        JsonElement minOccurs = element.get(MIN_OCCURS_KEY);
        if (minOccurs == null) {
            element.add(MIN_OCCURS_KEY, (JsonElement)new JsonPrimitive((Number)(isRequired ? 1 : 0)));
        }
        if ((maxOccurs = element.get(MAX_OCCURS_KEY)) == null) {
            element.add(MAX_OCCURS_KEY, (JsonElement)new JsonPrimitive((Number)1));
        }
    }

    private boolean isRequired(JsonObject element) {
        JsonElement isRequired = element.get("isRequired");
        return isRequired != null && isRequired.getAsBoolean();
    }
}

