/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;

public class LegacyNestedRouteModelTypeAdapter
extends TypeAdapter<NestableElementModel> {
    private static final String NESTED_COMPONENTS_KEY = "nestedComponents";
    private static final String CHILD_COMPONENTS_KEY = "childComponents";
    private final TypeAdapter<NestableElementModel> delegate;
    private final Gson gson;

    public LegacyNestedRouteModelTypeAdapter(TypeAdapter<NestableElementModel> delegate, Gson gson) {
        this.delegate = delegate;
        this.gson = gson;
    }

    public void write(JsonWriter out, NestableElementModel value) throws IOException {
        JsonObject element = this.delegate.toJsonTree((Object)value).getAsJsonObject();
        this.renameKey((JsonElement)element, NESTED_COMPONENTS_KEY, CHILD_COMPONENTS_KEY);
        this.gson.toJson((JsonElement)element, out);
    }

    public NestableElementModel read(JsonReader in) throws IOException {
        JsonElement element = new JsonParser().parse(in);
        this.renameKey(element, CHILD_COMPONENTS_KEY, NESTED_COMPONENTS_KEY);
        return (NestableElementModel)this.delegate.fromJsonTree(element);
    }

    private void renameKey(JsonElement element, String currentKey, String newKey) {
        JsonObject object;
        JsonElement target;
        if (element.isJsonObject() && (target = (object = element.getAsJsonObject()).remove(currentKey)) != null) {
            object.add(newKey, target);
        }
    }
}

