/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.internal.persistence.ErrorModelToIdentifierSerializer;

class ErrorModelSerializerDelegate {
    private static final String MULE = "MULE";
    private static final String ERROR = "error";
    private static final String PARENT = "parent";
    private static final String EMPTY = "";
    private Map<String, ErrorModel> errorModelRespository;

    ErrorModelSerializerDelegate(Map<String, ErrorModel> errorModelRespository) {
        this.errorModelRespository = errorModelRespository;
    }

    void writeErrors(Set<ErrorModel> errorModels, JsonWriter out) throws IOException {
        Set<ErrorModel> models = this.flatenizeErrors(errorModels);
        out.name("errors");
        out.beginArray();
        for (ErrorModel errorModel : models) {
            this.writeError(out, errorModel);
        }
        out.endArray();
    }

    private void writeError(JsonWriter out, ErrorModel errorModel) throws IOException {
        String namespace = errorModel.getNamespace();
        if (!namespace.equals(MULE)) {
            out.beginObject();
            out.name(ERROR).value(ErrorModelToIdentifierSerializer.serialize(errorModel));
            if (errorModel.getParent().isPresent()) {
                out.name(PARENT).value(ErrorModelToIdentifierSerializer.serialize((ErrorModel)errorModel.getParent().get()));
            }
            out.endObject();
        }
    }

    Set<ErrorModel> getErrors(JsonArray errors) {
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errors.iterator().forEachRemaining(model -> this.errorModelRespository.get(model.getAsJsonObject().get(ERROR).getAsString()));
        return errorModels;
    }

    private Set<ErrorModel> flatenizeErrors(Set<ErrorModel> errorModels) {
        HashSet<ErrorModel> models = new HashSet<ErrorModel>();
        errorModels.forEach(model -> {
            models.add((ErrorModel)model);
            Optional parent = model.getParent();
            while (parent.isPresent()) {
                ErrorModel parentModel = (ErrorModel)parent.get();
                models.add(parentModel);
                parent = parentModel.getParent();
            }
        });
        return models;
    }

    Map<String, ErrorModel> parseErrors(JsonArray errors) {
        HashMap buildingErrors = new HashMap();
        errors.iterator().forEachRemaining(element -> {
            JsonObject error = element.getAsJsonObject();
            String anError = error.get(ERROR).getAsString();
            String parentError = EMPTY;
            if (error.has(PARENT)) {
                parentError = error.get(PARENT).getAsString();
            }
            buildingErrors.put(anError, new Pair((Object)parentError, (Object)ErrorModelBuilder.newError((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)anError))));
        });
        buildingErrors.keySet().forEach(key -> this.buildError((String)key, buildingErrors, this.errorModelRespository));
        return this.errorModelRespository;
    }

    private ErrorModel buildError(String errorIdentifier, Map<String, Pair<String, ErrorModelBuilder>> buildingErrors, Map<String, ErrorModel> builtErrorModels) {
        if (builtErrorModels.containsKey(errorIdentifier)) {
            return builtErrorModels.get(errorIdentifier);
        }
        Pair<String, ErrorModelBuilder> builderPair = buildingErrors.get(errorIdentifier);
        if (builderPair != null) {
            String parentError = (String)builderPair.getFirst();
            ErrorModel errorModel = ((ErrorModelBuilder)builderPair.getSecond()).withParent(this.buildError(parentError, buildingErrors, builtErrorModels)).build();
            builtErrorModels.put(errorIdentifier, errorModel);
            return errorModel;
        }
        ComponentIdentifier identifier = ComponentIdentifier.buildFromStringRepresentation((String)errorIdentifier);
        return identifier.getNamespace().equals(MULE) ? this.buildMuleError(identifier, builtErrorModels) : this.buildSimpleError(identifier, builtErrorModels);
    }

    private ErrorModel buildMuleError(ComponentIdentifier identifier, Map<String, ErrorModel> builtErrors) {
        String errorType = identifier.getName();
        try {
            MuleErrors muleErrors = MuleErrors.valueOf((String)errorType);
            Optional parent = muleErrors.getParent();
            if (parent.isPresent()) {
                ErrorModel errorModel = ErrorModelBuilder.newError((String)errorType, (String)identifier.getNamespace()).withParent(this.buildMuleError(ComponentIdentifier.builder().namespace(MULE).name(((ErrorTypeDefinition)parent.get()).getType()).build(), builtErrors)).build();
                builtErrors.put(identifier.toString(), errorModel);
                return errorModel;
            }
            return this.buildSimpleError(identifier, builtErrors);
        }
        catch (IllegalArgumentException e) {
            return this.buildSimpleError(identifier, builtErrors);
        }
    }

    private ErrorModel buildSimpleError(ComponentIdentifier identifier, Map<String, ErrorModel> builtErrors) {
        ErrorModel errorModel = ErrorModelBuilder.newError((ComponentIdentifier)identifier).build();
        builtErrors.put(identifier.toString(), errorModel);
        return errorModel;
    }
}

