/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.internal.DefaultObjectFieldHandler;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.ast.extension.internal.ASTParameterizableType;
import org.mule.runtime.ast.extension.internal.ASTType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public final class ExtensionTypeObjectFieldHandler
implements ObjectFieldHandler {
    private final ProcessingEnvironment processingEnvironment;

    ExtensionTypeObjectFieldHandler(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public void handle(Element element, ObjectTypeBuilder builder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        if (element instanceof TypeElement) {
            ASTParameterizableType type = new ASTParameterizableType((TypeElement)element, this.processingEnvironment);
            if (type.isSameType(Chain.class)) {
                return;
            }
            this.processAnnotations(element, builder);
            List parameters = type.getParameters();
            if (parameters.isEmpty()) {
                this.fallbackToBeanProperties(element, builder, context, typeVisitor);
                return;
            }
            for (ExtensionParameter parameter : parameters) {
                ObjectFieldTypeBuilder fieldBuilder = builder.addField();
                fieldBuilder.key(parameter.getAlias());
                parameter.getElement().ifPresent(e -> this.extractJavadoc(this.processingEnvironment, (Element)e).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).description(arg_0)));
                this.setFieldType(parameter, fieldBuilder, context, typeVisitor);
            }
        }
    }

    private void fallbackToBeanProperties(Element element, ObjectTypeBuilder builder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        if (!element.getKind().equals((Object)ElementKind.INTERFACE)) {
            new DefaultObjectFieldHandler(this.processingEnvironment).handle(element, builder, context, typeVisitor);
        }
    }

    private void setFieldType(ExtensionParameter parameter, ObjectFieldTypeBuilder fieldBuilder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        Type type = parameter.getType();
        Optional optionalElement = type.getElement();
        if (optionalElement.isPresent()) {
            TypeElement typeElement = (TypeElement)optionalElement.get();
            if (context.contains((Element)typeElement)) {
                fieldBuilder.value(context.get((Element)typeElement));
            } else {
                fieldBuilder.value(((ASTType)type).getTypeMirror().accept(typeVisitor, context));
            }
        } else {
            fieldBuilder.value(type.asMetadataType());
        }
    }

    private Optional<String> extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (comment == null || comment.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(comment.trim().replaceAll("\\{@[^ ]+ ([^\\}]+)\\}", "$1"));
    }

    private void processAnnotations(Element element, ObjectTypeBuilder builder) {
        this.processExtensible(element, builder);
        this.processTypeAlias(element, builder);
        this.processTypeDsl(element, builder);
    }

    private void processExtensible(Element element, ObjectTypeBuilder builder) {
        if (this.getAnnotation(element, Extensible.class.getName()).isPresent() || this.getAnnotation(element, org.mule.sdk.api.annotation.Extensible.class.getName()).isPresent()) {
            builder.with((TypeAnnotation)new ExtensibleTypeAnnotation());
        }
    }

    private void processTypeAlias(Element element, ObjectTypeBuilder builder) {
        Map<String, Object> annotationValues = this.getAnnotationValues(element, Alias.class.getName(), org.mule.sdk.api.annotation.Alias.class.getName());
        if (!annotationValues.isEmpty()) {
            builder.with((TypeAnnotation)new TypeAliasAnnotation((String)annotationValues.get("value")));
        }
    }

    private void processTypeDsl(Element element, ObjectTypeBuilder builder) {
        Map<String, Object> annotationValues = this.getAnnotationValues(element, TypeDsl.class.getName());
        if (!annotationValues.isEmpty()) {
            builder.with((TypeAnnotation)new TypeDslAnnotation(((Boolean)annotationValues.getOrDefault("allowInlineDefinition", true)).booleanValue(), ((Boolean)annotationValues.getOrDefault("allowTopLevelDefinition", false)).booleanValue(), (String)annotationValues.getOrDefault("substitutionGroup", ""), (String)annotationValues.getOrDefault("baseType", "")));
        }
    }

    private Optional<? extends AnnotationMirror> getAnnotation(Element element, String annotationName) {
        return element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationName)).findFirst();
    }

    private Map<String, Object> getAnnotationValues(Element element, String ... annotationNames) {
        SmallMap annotationValues = new SmallMap();
        for (String annotationName : annotationNames) {
            Optional<? extends AnnotationMirror> annotationMirror = this.getAnnotation(element, annotationName);
            if (!annotationMirror.isPresent()) continue;
            AnnotationMirror a = annotationMirror.get();
            a.getElementValues().forEach((arg_0, arg_1) -> ExtensionTypeObjectFieldHandler.lambda$getAnnotationValues$2((Map)annotationValues, arg_0, arg_1));
            break;
        }
        return annotationValues;
    }

    private static /* synthetic */ void lambda$getAnnotationValues$2(Map annotationValues, ExecutableElement key, AnnotationValue value) {
        annotationValues.put(key.getSimpleName().toString(), value.getValue());
    }
}

