/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class IntrospectionTypeUtils {
    private IntrospectionTypeUtils() {
    }

    public static List<? extends TypeMirror> getSuperTypeGenerics(TypeMirror type, Class superClass, ProcessingEnvironment processingEnvironment) {
        TypeElement superClassTypeElement = processingEnvironment.getElementUtils().getTypeElement(superClass.getCanonicalName());
        TypeElement objectType = processingEnvironment.getElementUtils().getTypeElement(Object.class.getName());
        TypeMirror superClassTypeMirror = processingEnvironment.getTypeUtils().erasure(superClassTypeElement.asType());
        if (!processingEnvironment.getTypeUtils().isAssignable(type, superClassTypeMirror)) {
            throw new IllegalArgumentException(String.format("Class '%s' does not extend the '%s' class", type.toString(), superClass.getSimpleName()));
        }
        if (IntrospectionTypeUtils.isSameType(type, processingEnvironment, superClassTypeMirror)) {
            return IntrospectionTypeUtils.getGenericTypes(type);
        }
        DeclaredType searchClass = (DeclaredType)type;
        while (!processingEnvironment.getTypeUtils().isAssignable(objectType.asType(), searchClass)) {
            for (TypeMirror typeMirror : processingEnvironment.getTypeUtils().directSupertypes(searchClass)) {
                if (IntrospectionTypeUtils.isSameType(typeMirror, processingEnvironment, superClassTypeMirror)) {
                    return IntrospectionTypeUtils.getGenericTypes(typeMirror);
                }
                if (!(typeMirror instanceof DeclaredType) || !processingEnvironment.getTypeUtils().isAssignable(typeMirror, superClassTypeMirror)) continue;
                searchClass = (DeclaredType)typeMirror;
            }
        }
        return Collections.emptyList();
    }

    private static List<? extends TypeMirror> getGenericTypes(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            return ((DeclaredType)typeMirror).getTypeArguments();
        }
        return Collections.emptyList();
    }

    private static boolean isSameType(TypeMirror type, ProcessingEnvironment processingEnvironment, TypeMirror superClassTypeMirror) {
        return processingEnvironment.getTypeUtils().isSameType(processingEnvironment.getTypeUtils().erasure(type), superClassTypeMirror);
    }

    public static List<? extends TypeMirror> getSuperTypeGenerics(TypeElement type, Class superClass, ProcessingEnvironment processingEnvironment) {
        return IntrospectionTypeUtils.getSuperTypeGenerics(type.asType(), superClass, processingEnvironment);
    }
}

