/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.runtime.module.embedded.internal.utils.DependenciesUtils;
import org.mule.runtime.module.embedded.internal.utils.Preconditions;

public class MavenClientMuleDependenciesResolver
implements MuleDependenciesResolver {
    private static final Collection<ExcludedDependency> EXCLUDED_DEPENDENCIES = new ArrayList<ExcludedDependency>();
    private static final String CE_PATCHES_GROUP_ID = "org.mule.patches";
    private static final String EE_PATCHES_GROUP_ID = "com.mulesoft.mule.patches";
    private final BundleDescriptor muleLibsBom;
    private final BundleDescriptor muleServicesBom;
    private final List<BundleDescriptor> serverPlugins;
    private final DependencyResolver dependencyResolver;
    private final boolean sanitize;
    private Map<Boolean, List<BundleDependency>> containerDependencies;
    private List<URL> muleUrls;
    private List<URL> optUrls;
    private List<URL> servicesUrls;
    private List<URL> serverPluginsUrls;

    public MavenClientMuleDependenciesResolver(BundleDescriptor muleLibsBom, BundleDescriptor muleServicesBom, List<BundleDescriptor> serverPlugins, DependencyResolver dependencyResolver, boolean sanitize) {
        this.muleLibsBom = muleLibsBom;
        this.muleServicesBom = muleServicesBom;
        this.serverPlugins = serverPlugins;
        this.dependencyResolver = dependencyResolver;
        this.sanitize = sanitize;
    }

    @Override
    public List<URL> resolveMuleLibs() {
        if (this.containerDependencies == null) {
            this.resolveContainerDependencies();
        }
        return this.muleUrls;
    }

    @Override
    public List<URL> resolveOptLibs() {
        if (this.containerDependencies == null) {
            this.resolveContainerDependencies();
        }
        return this.optUrls;
    }

    private void resolveContainerDependencies() {
        this.containerDependencies = this.dependencyResolver.resolveBundleDescriptorDependencies(this.muleLibsBom).stream().filter(bundleDependency -> !bundleDependency.getDescriptor().getGroupId().equals("org.mule.services")).filter(this::shouldKeepXmlApis).filter(bundleDependency -> !bundleDependency.getDescriptor().getType().equals("pom")).sorted((dependency1, dependency2) -> {
            if (MavenClientMuleDependenciesResolver.isPatchDependency(dependency1)) {
                return -1;
            }
            if (MavenClientMuleDependenciesResolver.isPatchDependency(dependency2)) {
                return 1;
            }
            return 0;
        }).collect(Collectors.partitioningBy(bundleDependency -> this.isMuleContainerGroupId(bundleDependency.getDescriptor().getGroupId())));
        this.muleUrls = this.containerDependencies.get(true).stream().map(DependenciesUtils.dependencyToUrl()).collect(Collectors.toList());
        this.optUrls = this.containerDependencies.get(false).stream().filter(this::sanitizeOptDependencies).map(DependenciesUtils.dependencyToUrl()).collect(Collectors.toList());
    }

    @Override
    public List<URL> resolveMuleServices() {
        if (this.servicesUrls == null) {
            this.servicesUrls = this.dependencyResolver.resolveBundleDescriptorDependencies(this.muleServicesBom).stream().filter(this::isService).map(DependenciesUtils.dependencyToUrl()).collect(Collectors.toList());
        }
        return this.servicesUrls;
    }

    @Override
    public List<URL> resolveServerPlugins() {
        if (this.serverPluginsUrls == null) {
            this.serverPluginsUrls = this.serverPlugins.stream().map(this.dependencyResolver::resolveBundleDescriptor).map(DependenciesUtils.dependencyToUrl()).collect(Collectors.toList());
        }
        return this.serverPluginsUrls;
    }

    private boolean isMuleContainerGroupId(String groupId) {
        return groupId.equals("org.mule.runtime") || groupId.equals("org.mule.runtime.boot") || groupId.equals("org.mule.sdk") || groupId.equals("org.mule.weave") || groupId.equals("org.mule.mvel") || groupId.equals("org.mule.commons") || groupId.equals("com.mulesoft.mule.runtime") || groupId.equals("com.mulesoft.mule.runtime.boot") || groupId.equals("com.mulesoft.mule.runtime.modules") || groupId.equals("com.mulesoft.anypoint") || groupId.equals("com.mulesoft.connectivity");
    }

    private static boolean isPatchDependency(BundleDependency dependency) {
        String groupId = dependency.getDescriptor().getGroupId();
        return groupId.equals(CE_PATCHES_GROUP_ID) || groupId.equals(EE_PATCHES_GROUP_ID);
    }

    private boolean shouldKeepXmlApis(BundleDependency bundleDependency) {
        if (SystemUtils.IS_JAVA_1_8) {
            return true;
        }
        BundleDescriptor bundleDescriptor = bundleDependency.getDescriptor();
        return !bundleDescriptor.getGroupId().equals("xml-apis") || !bundleDescriptor.getArtifactId().equals("xml-apis");
    }

    private boolean isService(BundleDependency dependency) {
        return dependency.getDescriptor().getClassifier().map(classifier -> classifier.equals("mule-service")).orElse(false);
    }

    private boolean sanitizeOptDependencies(BundleDependency bundleDependency) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17) && this.sanitize) {
            return EXCLUDED_DEPENDENCIES.stream().noneMatch(excludedDependency -> excludedDependency.match(bundleDependency));
        }
        return true;
    }

    static {
        EXCLUDED_DEPENDENCIES.add(new ExcludedDependency("org.apache.logging.log4j"));
        EXCLUDED_DEPENDENCIES.add(new ExcludedDependency("com.lmax", "disruptor"));
    }

    private static class ExcludedDependency {
        private final String groupId;
        private final String artifactId;

        public ExcludedDependency(String groupId) {
            this(groupId, null);
        }

        public ExcludedDependency(String groupId, String artifactId) {
            Preconditions.checkArgument(groupId != null, "'groupId' can't be null");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean match(BundleDependency bundleDependency) {
            boolean match = this.groupId.equals(bundleDependency.getDescriptor().getGroupId());
            if (this.artifactId != null) {
                match = match && this.artifactId.equals(bundleDependency.getDescriptor().getArtifactId());
            }
            return match;
        }
    }
}

