/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.RuntimeProduct;

public class MavenContainerOptSeparateClassLoaderFactory
extends MavenContainerClassLoaderFactory {
    public MavenContainerOptSeparateClassLoaderFactory(MavenClient mavenClient) {
        super(mavenClient);
    }

    @Override
    public ClassLoader create(RuntimeProduct runtimeProduct, URL containerBaseFolder) {
        try {
            List<BundleDependency> bundleDependencies = this.resolveDependencies(runtimeProduct);
            Map<Boolean, List<BundleDependency>> partitionedDependencies = bundleDependencies.stream().collect(Collectors.partitioningBy(bundleDependency -> this.isMuleContainerGroupId(bundleDependency.getDescriptor().getGroupId())));
            List<URL> muleUrls = partitionedDependencies.get(true).stream().map(this.dependencyToUrl()).collect(Collectors.toList());
            List<URL> optUrls = partitionedDependencies.get(false).stream().map(this.dependencyToUrl()).collect(Collectors.toList());
            File containerFolderFile = FileUtils.toFile((URL)containerBaseFolder);
            URL configurationFolderUrl = new URL(new File(containerFolderFile, "conf").toURI() + "/");
            URLClassLoader parentClassLoader = new URLClassLoader(Collections.singletonList(configurationFolderUrl).toArray(new URL[1]), this.buildParentClassLoader(this.getClass().getClassLoader()));
            return JpmsUtils.createModuleLayerClassLoader((URL[])optUrls.toArray(new URL[optUrls.size()]), (URL[])muleUrls.toArray(new URL[muleUrls.size()]), (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)parentClassLoader, Optional.of(this.getClass()));
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMuleContainerGroupId(String groupId) {
        return groupId.equals("org.mule.runtime") || groupId.equals("org.mule.runtime.boot") || groupId.equals("org.mule.sdk") || groupId.equals("org.mule.weave") || groupId.equals("org.mule.mvel") || groupId.equals("org.mule.commons") || groupId.equals("com.mulesoft.mule.runtime") || groupId.equals("com.mulesoft.mule.runtime.boot") || groupId.equals("com.mulesoft.mule.runtime.modules") || groupId.equals("com.mulesoft.anypoint");
    }
}

