/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.Serializer;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmbeddedContainerBuilder
implements EmbeddedContainer.EmbeddedContainerBuilder {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultEmbeddedContainerBuilder.class);
    private String muleVersion;
    private URI log4jConfigurationFile;
    private MavenConfiguration mavenConfiguration;
    private ContainerConfiguration containerConfiguration;
    private Product product;

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder muleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder product(Product product) {
        this.product = product;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder containerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder log4jConfigurationFile(URI log4JConfigurationFile) {
        this.log4jConfigurationFile = log4JConfigurationFile;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder mavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer build() {
        Preconditions.checkState((this.muleVersion != null ? 1 : 0) != 0, (Object)"muleVersion cannot be null");
        Preconditions.checkState((this.mavenConfiguration != null ? 1 : 0) != 0, (Object)"mavenConfiguration cannot be null");
        Preconditions.checkState((this.containerConfiguration != null ? 1 : 0) != 0, (Object)"containerConfiguration cannot be null");
        Preconditions.checkState((this.log4jConfigurationFile != null ? 1 : 0) != 0, (Object)"log4jConfigurationFile cannot be null");
        Preconditions.checkState((this.product != null ? 1 : 0) != 0, (Object)"product cannot be null");
        try {
            final URL containerBaseFolder = this.containerConfiguration.getContainerFolder().toURI().toURL();
            if (this.log4jConfigurationFile != null) {
                File confDir = new File(FileUtils.toFile((URL)containerBaseFolder), "conf");
                confDir.mkdirs();
                try (InputStream log4jConfFileInputStream = this.log4jConfigurationFile.toURL().openStream();){
                    org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)log4jConfFileInputStream, (File)new File(confDir, "log4j2.xml"));
                }
            }
            final FilteringClassLoader jdkOnlyClassLoader = JdkOnlyClassLoaderFactory.create(this.getClass().getClassLoader());
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)this.getClass().getClassLoader());
            final MavenClient mavenClient = mavenClientProvider.createMavenClient(this.mavenConfiguration);
            this.persistMavenConfiguration(containerBaseFolder, this.mavenConfiguration);
            final MavenContainerClassLoaderFactory classLoaderFactory = new MavenContainerClassLoaderFactory(mavenClient);
            try {
                return new EmbeddedContainer(){
                    private boolean started = false;
                    private Object embeddedController;
                    private ClassLoader containerModulesClassLoader;
                    private ClassLoader embeddedControllerBootstrapClassLoader;
                    private ExecutorService executorService;

                    @Override
                    public synchronized void start() {
                        if (!this.started) {
                            try {
                                this.containerModulesClassLoader = classLoaderFactory.create(DefaultEmbeddedContainerBuilder.this.muleVersion, DefaultEmbeddedContainerBuilder.this.product, jdkOnlyClassLoader, containerBaseFolder.toURI().toURL());
                                this.embeddedControllerBootstrapClassLoader = DefaultEmbeddedContainerBuilder.createEmbeddedImplClassLoader(this.containerModulesClassLoader, mavenClient, DefaultEmbeddedContainerBuilder.this.muleVersion, DefaultEmbeddedContainerBuilder.this.product);
                                List<URL> services = classLoaderFactory.getServices(DefaultEmbeddedContainerBuilder.this.muleVersion, DefaultEmbeddedContainerBuilder.this.product);
                                List serverPlugins = DefaultEmbeddedContainerBuilder.this.getServerPlugins(mavenClient, DefaultEmbeddedContainerBuilder.this.containerConfiguration.getServerPlugins());
                                ContainerInfo containerInfo = new ContainerInfo(DefaultEmbeddedContainerBuilder.this.muleVersion, containerBaseFolder, services, serverPlugins);
                                Class<?> controllerClass = this.embeddedControllerBootstrapClassLoader.loadClass("org.mule.runtime.module.embedded.impl.EmbeddedController");
                                Constructor<?> constructor = controllerClass.getConstructor(byte[].class);
                                ByteArrayOutputStream containerOutputStream = new ByteArrayOutputStream(512);
                                Serializer.serialize(containerInfo, containerOutputStream);
                                this.executorService = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "Embedded"));
                                this.embeddedController = constructor.newInstance(new Object[]{containerOutputStream.toByteArray()});
                            }
                            catch (Exception e) {
                                this.doStop();
                                throw new IllegalStateException("Cannot start embedded container", e);
                            }
                            this.started = true;
                            this.executeUsingReflection(() -> this.embeddedController.getClass().getMethod("start", new Class[0]), Collections.emptyList());
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Embedded container already started");
                        }
                    }

                    @Override
                    public synchronized void stop() {
                        if (this.started) {
                            try {
                                this.doStop();
                            }
                            finally {
                                this.started = false;
                            }
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Embedded container already stopped");
                        }
                    }

                    private void doStop() {
                        if (this.embeddedController != null) {
                            this.executeUsingReflection(() -> this.embeddedController.getClass().getMethod("stop", new Class[0]), Collections.emptyList());
                            this.embeddedController = null;
                        }
                        if (this.executorService != null) {
                            this.executorService.shutdownNow();
                            this.executorService = null;
                        }
                        this.closeClassLoader(this.containerModulesClassLoader);
                        this.containerModulesClassLoader = null;
                        this.closeClassLoader(this.embeddedControllerBootstrapClassLoader);
                        this.embeddedControllerBootstrapClassLoader = null;
                    }

                    private void closeClassLoader(ClassLoader classLoader) {
                        block3: {
                            if (classLoader instanceof Closeable) {
                                try {
                                    ((Closeable)((Object)classLoader)).close();
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isDebugEnabled()) break block3;
                                    LOGGER.debug("Failure closing container classloader", (Throwable)e);
                                }
                            }
                        }
                    }

                    @Override
                    public DeploymentService getDeploymentService() {
                        return new DeploymentService(){

                            @Override
                            public void deployApplication(ArtifactConfiguration artifactConfiguration) {
                                this.executeUsingReflection(() -> this.findEmbeddedMethod("deployApplication"), Collections.singletonList(artifactConfiguration));
                            }

                            @Override
                            public void undeployApplication(String applicationName) {
                                this.executeUsingReflection(() -> this.findEmbeddedMethod("undeployApplication"), Collections.singletonList(applicationName));
                            }

                            @Override
                            public void deployDomain(ArtifactConfiguration artifactConfiguration) {
                                this.executeUsingReflection(() -> this.findEmbeddedMethod("deployDomain"), Collections.singletonList(artifactConfiguration));
                            }

                            @Override
                            public void undeployDomain(String domainName) {
                                this.executeUsingReflection(() -> this.findEmbeddedMethod("undeployDomain"), Collections.singletonList(domainName));
                            }
                        };
                    }

                    @Override
                    public File getContainerFolder() {
                        return DefaultEmbeddedContainerBuilder.this.containerConfiguration.getContainerFolder();
                    }

                    private Method findEmbeddedMethod(String methodName) {
                        Method[] methods;
                        for (Method method : methods = this.embeddedController.getClass().getMethods()) {
                            if (!method.getName().equals(methodName)) continue;
                            return method;
                        }
                        throw new RuntimeException(new NoSuchMethodException("Method " + methodName + " not found"));
                    }

                    private void executeUsingReflection(UncheckedSupplier<Method> methodSupplier, List<Serializable> args) {
                        Future<?> future = this.executorService.submit(() -> {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(this.containerModulesClassLoader);
                                Method method = (Method)methodSupplier.get();
                                List<Object> arguments = args.stream().map(arg -> {
                                    ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                                    Serializer.serialize(arg, byteOutputStream);
                                    return byteOutputStream.toByteArray();
                                }).collect(Collectors.toList());
                                method.invoke(this.embeddedController, arguments.toArray(new Object[arguments.size()]));
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                throw new IllegalStateException(cause);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(e);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(contextClassLoader);
                            }
                        });
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create embedded container", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> getServerPlugins(MavenClient mavenClient, List<BundleDescriptor> serverPlugins) {
        return serverPlugins.stream().map(serverPluginDescriptor -> {
            BundleDependency bundleDependency = mavenClient.resolveBundleDescriptor(serverPluginDescriptor);
            try {
                return bundleDependency.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private void persistMavenConfiguration(URL containerBaseFolder, MavenConfiguration mavenConfiguration) throws IOException {
        File configurationFolder = new File(FileUtils.toFile((URL)containerBaseFolder), "conf");
        if (!configurationFolder.exists() && !configurationFolder.mkdirs()) {
            throw new IllegalArgumentException("Could not create MULE_HOME/conf folder in: " + configurationFolder.getAbsolutePath());
        }
        JsonObject rootObject = new JsonObject();
        JsonObject muleRuntimeConfigObject = new JsonObject();
        rootObject.add("muleRuntimeConfig", (JsonElement)muleRuntimeConfigObject);
        JsonObject mavenObject = new JsonObject();
        muleRuntimeConfigObject.add("maven", (JsonElement)mavenObject);
        if (!mavenConfiguration.getMavenRemoteRepositories().isEmpty()) {
            JsonObject repositoriesObject = new JsonObject();
            mavenObject.add("repositories", (JsonElement)repositoriesObject);
            mavenConfiguration.getMavenRemoteRepositories().forEach(mavenRepo -> {
                JsonObject repoObject = new JsonObject();
                repositoriesObject.add(mavenRepo.getId(), (JsonElement)repoObject);
                repoObject.addProperty("url", mavenRepo.getUrl().toString());
                mavenRepo.getAuthentication().ifPresent(authentication -> {
                    repoObject.addProperty("username", authentication.getUsername());
                    repoObject.addProperty("password", authentication.getPassword());
                });
                mavenRepo.getSnapshotPolicy().ifPresent(snapshotPolicy -> {
                    JsonObject snapshotPolicyObject = new JsonObject();
                    snapshotPolicyObject.addProperty("enabled", Boolean.valueOf(snapshotPolicy.isEnabled()));
                    snapshotPolicyObject.addProperty("updatePolicy", snapshotPolicy.getUpdatePolicy());
                    snapshotPolicyObject.addProperty("checksumPolicy", snapshotPolicy.getChecksumPolicy());
                    repoObject.add("snapshotPolicy", (JsonElement)snapshotPolicyObject);
                });
                mavenRepo.getReleasePolicy().ifPresent(releasePolicy -> {
                    JsonObject releasePolicyObject = new JsonObject();
                    releasePolicyObject.addProperty("enabled", Boolean.valueOf(releasePolicy.isEnabled()));
                    releasePolicyObject.addProperty("updatePolicy", releasePolicy.getUpdatePolicy());
                    releasePolicyObject.addProperty("checksumPolicy", releasePolicy.getChecksumPolicy());
                    repoObject.add("releasePolicy", (JsonElement)releasePolicyObject);
                });
            });
        }
        mavenObject.addProperty("repositoryLocation", mavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath());
        mavenConfiguration.getUserSettingsLocation().ifPresent(userSettingsLocation -> mavenObject.addProperty("userSettingsLocation", userSettingsLocation.getAbsolutePath()));
        mavenConfiguration.getGlobalSettingsLocation().ifPresent(globalSettingsLocation -> mavenObject.addProperty("globalSettingsLocation", globalSettingsLocation.getAbsolutePath()));
        mavenObject.addProperty("ignoreArtifactDescriptorRepositories", Boolean.valueOf(mavenConfiguration.getIgnoreArtifactDescriptorRepositories()));
        mavenConfiguration.getSettingsSecurityLocation().ifPresent(securitySettingsLocation -> mavenObject.addProperty("settingsSecurityLocation", securitySettingsLocation.getAbsolutePath()));
        mavenObject.addProperty("forcePolicyUpdateNever", Boolean.valueOf(mavenConfiguration.getForcePolicyUpdateNever()));
        mavenObject.addProperty("forcePolicyUpdateAlways", Boolean.valueOf(mavenConfiguration.getForcePolicyUpdateAlways()));
        mavenObject.addProperty("offLineMode", Boolean.valueOf(mavenConfiguration.getOfflineMode()));
        String muleConfigContent = new Gson().toJson((JsonElement)rootObject);
        FileUtils.fileWrite((File)new File(configurationFolder, "mule-config.json"), (String)muleConfigContent);
    }

    private static ClassLoader createEmbeddedImplClassLoader(ClassLoader parentClassLoader, MavenClient mavenClient, String muleVersion, Product product) throws MalformedURLException {
        BundleDescriptor embeddedBomDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.distributions").setArtifactId("mule-module-embedded-impl-bom").setVersion(muleVersion).setType("pom").build();
        BundleDescriptor embeddedImplDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.distributions").setArtifactId("mule-module-embedded-impl").setVersion(muleVersion).setType("jar").build();
        BundleDependency embeddedBundleImplDescriptor = mavenClient.resolveBundleDescriptor(embeddedImplDescriptor);
        List embeddedImplDependencies = mavenClient.resolveBundleDescriptorDependencies(false, embeddedBomDescriptor);
        List<URL> embeddedUrls = embeddedImplDependencies.stream().filter(bundleDependency -> !bundleDependency.getScope().equals((Object)BundleScope.PROVIDED)).map(dep -> {
            try {
                return dep.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        embeddedUrls.add(embeddedBundleImplDescriptor.getBundleUri().toURL());
        return new URLClassLoader(embeddedUrls.toArray(new URL[embeddedUrls.size()]), parentClassLoader);
    }

    static interface UncheckedSupplier<T> {
        public T get() throws Exception;
    }
}

