/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.classloading;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ClassLoaderFilter {
    private static final String EMPTY_PACKAGE = "";
    private static final char RESOURCE_SEPARATOR = '/';
    public static final String CLASS_PACKAGE_SPLIT_REGEX = "\\.";
    public static final String RESOURCE_PACKAGE_SPLIT_REGEX = "/";
    private final Set<String> bootPackages;

    public ClassLoaderFilter(Set<String> bootPackages) {
        this.bootPackages = bootPackages;
    }

    public boolean exportsClass(String name) {
        return this.isExportedBootPackage(name, CLASS_PACKAGE_SPLIT_REGEX);
    }

    public boolean exportsResource(String name) {
        return this.isExportedBootPackage(name, RESOURCE_PACKAGE_SPLIT_REGEX);
    }

    private boolean isExportedBootPackage(String name, String splitRegex) {
        boolean exported = false;
        String[] splitName = name.split(splitRegex);
        String[] packages = Arrays.copyOf(splitName, splitName.length - 1);
        String candidatePackage = EMPTY_PACKAGE;
        for (String currentPackage : packages) {
            if (candidatePackage.length() != 0) {
                candidatePackage = candidatePackage + ".";
            }
            if (!this.bootPackages.contains(candidatePackage = candidatePackage + currentPackage)) continue;
            exported = true;
            break;
        }
        return exported;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

