/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaParameter;

import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchemaParameter}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaParameter implements ConnectivitySchemaParameter {

  private String propertyTerm;
  private String range;
  private boolean mandatory;

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPropertyTerm() {
    return propertyTerm;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getRange() {
    return range;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isMandatory() {
    return mandatory;
  }

  public void setPropertyTerm(String propertyTerm) {
    this.propertyTerm = propertyTerm;
  }

  public void setRange(String range) {
    this.range = range;
  }

  public void setMandatory(boolean mandatory) {
    this.mandatory = mandatory;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchemaParameter) {
      ConnectivitySchemaParameter that = (ConnectivitySchemaParameter) o;
      return mandatory == that.isMandatory()
          && Objects.equals(propertyTerm, that.getPropertyTerm())
          && Objects.equals(range, that.getRange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(propertyTerm, range, mandatory);
  }
}
