/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaDefinition;
import org.mule.runtime.connectivity.api.platform.schema.ExchangeAssetDescriptor;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchema}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchema implements ConnectivitySchema {

  private String groupId;
  private String artifactId;
  private String version;

  private Map<String, String> labels = new LinkedHashMap<>();
  private List<ExchangeAssetDescriptor> assets = new LinkedList<>();
  private DefaultConnectivitySchemaDefinition definition = new DefaultConnectivitySchemaDefinition();

  /**
   * {@inheritDoc}
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getArtifactId() {
    return artifactId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, String> getLabels() {
    return labels;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ExchangeAssetDescriptor> getAssets() {
    return assets;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectivitySchemaDefinition getDefinition() {
    return definition;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchema) {
      ConnectivitySchema that = (ConnectivitySchema) o;
      return Objects.equals(groupId, that.getGroupId())
          && Objects.equals(artifactId, that.getArtifactId())
          && Objects.equals(version, that.getVersion())
          && Objects.equals(labels, that.getLabels())
          && Objects.equals(assets, that.getAssets())
          && Objects.equals(definition, that.getDefinition());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, artifactId, version, labels, assets, definition);
  }
}
