/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema.extension;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;

/**
 * A {@link ModelProperty} which indicates that the enriched element should not be a part of any generated
 * {@link ConnectivitySchema}
 *
 * @since 1.0
 */
public class ExcludeFromConnectivitySchemaModelProperty implements ModelProperty {

  @Override
  public String getName() {
    return "ExcludeFromConnectivitySchema";
  }

  @Override
  public boolean isPublic() {
    return false;
  }
}
