/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclarationContainer;
import org.mule.runtime.app.declaration.api.EnrichableElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;

public abstract class ParameterizedElementDeclaration
extends EnrichableElementDeclaration
implements ElementDeclarationContainer {
    private Map<String, ParameterGroupElementDeclaration> groups = new LinkedHashMap<String, ParameterGroupElementDeclaration>();

    public Optional<ParameterGroupElementDeclaration> getParameterGroup(String name) {
        return Optional.ofNullable(this.groups.get(name));
    }

    public List<ParameterGroupElementDeclaration> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroupElementDeclaration>(this.groups.values()));
    }

    public void addParameterGroup(ParameterGroupElementDeclaration group) {
        group.setDeclaringExtension(this.declaringExtension);
        if (this.groups.containsKey(group.getName())) {
            this.groups.get(group.getName()).getParameters().addAll(group.getParameters());
        } else {
            this.groups.put(group.getName(), group);
        }
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        if (this.isParameterLocation(parts)) {
            String identifier = parts.get(1);
            if (StringUtils.isNumeric((CharSequence)identifier) && Integer.parseInt(identifier) < this.groups.size()) {
                return Optional.of((ElementDeclaration)this.groups.get(Integer.parseInt(identifier)));
            }
            return this.groups.values().stream().flatMap(g -> g.getParameters().stream()).filter(p -> p.getName().equals(identifier)).findFirst();
        }
        return Optional.empty();
    }

    private boolean isParameterLocation(List<String> parts) {
        return parts.get(0).equals("parameters") && parts.size() == 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedElementDeclaration) || !super.equals(o)) {
            return false;
        }
        ParameterizedElementDeclaration that = (ParameterizedElementDeclaration)o;
        return this.groups.equals(that.groups);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.groups.hashCode();
        return result;
    }
}

