/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import java.util.List;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class ErrorHandlerWrapperNode
implements ChainExecutionPathTree {
    private final ComponentAst componentAst;
    private final List<ChainExecutionPathTree> errorHandlerNodes;

    public ErrorHandlerWrapperNode(ComponentAst componentAst, List<ChainExecutionPathTree> errorHandlerNodes) {
        this.componentAst = componentAst;
        this.errorHandlerNodes = errorHandlerNodes;
    }

    @Override
    public void accept(ChainExecutionPathTreeVisitor visitor) {
        this.errorHandlerNodes.forEach(handler -> handler.accept(visitor));
    }

    @Override
    public ComponentAst getComponentAst() {
        return this.componentAst;
    }

    @Override
    public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
        return this.errorHandlerNodes.stream().anyMatch(eh -> eh.anyExecutionPathContains(predicate));
    }

    @Override
    public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
        return this.errorHandlerNodes.stream().allMatch(eh -> eh.allExecutionPathsContain(predicate));
    }
}

