/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.validation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidator;
import org.mule.runtime.ast.api.validation.ArtifactAstValidatorBuilder;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationsProvider;
import org.mule.runtime.ast.internal.validation.DefaultValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidatorBuilder
implements ArtifactAstValidatorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValidatorBuilder.class);
    private Consumer<ValidationsProvider> validationEnricher = p -> {};
    private Predicate<Validation> validationsFilter = v -> true;
    private ClassLoader artifactRegionClassLoader = Thread.currentThread().getContextClassLoader();
    private boolean waiveUnresolvedPropertiesOnParams = false;

    @Override
    public DefaultValidatorBuilder withValidationEnricher(Consumer<ValidationsProvider> validationEnricher) {
        this.validationEnricher = validationEnricher;
        return this;
    }

    @Override
    public DefaultValidatorBuilder withValidationsFilter(Predicate<Validation> validationsFilter) {
        this.validationsFilter = validationsFilter;
        return this;
    }

    @Override
    public DefaultValidatorBuilder withArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
        return this;
    }

    @Override
    public ArtifactAstValidatorBuilder ignoreParamsWithProperties(boolean waiveUnresolvedPropertiesOnParams) {
        this.waiveUnresolvedPropertiesOnParams = waiveUnresolvedPropertiesOnParams;
        return this;
    }

    @Override
    public ArtifactAstValidator build() {
        ArrayList<Validation> componentValidations = new ArrayList<Validation>();
        ArrayList<ArtifactValidation> artifactValidations = new ArrayList<ArtifactValidation>();
        LinkedHashMap providers = new LinkedHashMap();
        StreamSupport.stream(ServiceLoader.load(ValidationsProvider.class, MuleAstUtils.class.getClassLoader()).spliterator(), false).forEach(vp -> providers.putIfAbsent(vp.getClass(), vp));
        StreamSupport.stream(ServiceLoader.load(ValidationsProvider.class).spliterator(), false).forEach(vp -> providers.putIfAbsent(vp.getClass(), vp));
        providers.values().forEach(vp -> {
            vp.setArtifactRegionClassLoader(this.artifactRegionClassLoader);
            vp.setIgnoreParamsWithProperties(this.waiveUnresolvedPropertiesOnParams);
            this.validationEnricher.accept((ValidationsProvider)vp);
            ((List)vp.get()).stream().filter(this.validationsFilter).forEach(componentValidations::add);
            vp.getArtifactValidations().stream().filter(this.validationsFilter).forEach(artifactValidations::add);
        });
        LOGGER.debug("Discovered component validations: '{}'", componentValidations);
        LOGGER.debug("Discovered artifact validations: '{}'", artifactValidations);
        return new DefaultValidator(artifactValidations, componentValidations);
    }
}

