/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.validation;

import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

import java.util.List;

/**
 * Implementation of {@link ValidationResultItem} that keeps internal state for the result item.
 *
 * @since 1.0
 */
public class DefaultValidationResultItem implements ValidationResultItem {

  private final List<ComponentAst> components;
  private final List<ComponentParameterAst> parameters;
  private final Validation validation;
  private final String message;

  public DefaultValidationResultItem(List<ComponentAst> components, List<ComponentParameterAst> parameters, Validation validation,
                                     String message) {
    this.components = components;
    this.parameters = parameters;
    this.validation = validation;
    this.message = message;
  }

  @Override
  public List<ComponentAst> getComponents() {
    return components;
  }

  public List<ComponentParameterAst> getParameters() {
    return parameters;
  }

  @Override
  public Validation getValidation() {
    return validation;
  }

  @Override
  public String getMessage() {
    return message;
  }
}
