/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.validation;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.ast.api.util.MuleAstUtils;

import java.util.Collection;

/**
 * Contains the result of a call to {@link MuleAstUtils#validate(org.mule.runtime.ast.api.ArtifactAst)} for a given artifact.
 *
 * @since 1.0
 */
@NoImplement
public interface ValidationResult {

  /**
   * The returned collection contains one item for each validation that failed.
   * 
   * @return the details of the findings of the validation process.
   */
  Collection<ValidationResultItem> getItems();
}
