/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.error;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.util.LazyValue;

import java.util.ServiceLoader;
import java.util.function.Supplier;

/**
 * Allows the AST module to discover the errors declared by the runtime.
 * <p>
 * Instances of this class are discovered through SPI using the same classloader as the one used to load the AST module classes.
 */
public interface ErrorTypeRepositoryProvider extends Supplier<ErrorTypeRepository> {

  LazyValue<ErrorTypeRepository> CORE_ERROR_TYPE_REPO = new LazyValue<>(() -> {
    return ServiceLoader.load(ErrorTypeRepositoryProvider.class, ErrorTypeRepositoryProvider.class.getClassLoader())
        .iterator().next()
        .get();
  });

  public static ErrorTypeRepository getCoreErrorTypeRepo() {
    return CORE_ERROR_TYPE_REPO.get();
  }
}
