/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public final class ComponentLocationVisitor {
    private static final Class<? extends ModelProperty> customLocationPartModelPropertyClass;
    private static final Method customLocationPartModelIsIndexedMethod;
    private static final Method customLocationPartModelGetLocationPartMethod;
    private static final String PROCESSORS_PART_NAME = "processors";
    private static final String SOURCE_PART_NAME = "source";

    private ComponentLocationVisitor() {
    }

    public static void resolveLocation(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy) {
        DefaultComponentLocation componentLocation;
        if (componentModel.getLocation() != null) {
            return;
        }
        Optional<TypedComponentIdentifier> typedComponentIdentifier = Optional.of(TypedComponentIdentifier.builder().identifier(componentModel.getIdentifier()).type(componentModel.getComponentType()).build());
        if (hierarchy.isEmpty()) {
            String componentModelNameAttribute = componentModel.getComponentId().orElse(null);
            ImmutableList parts = ImmutableList.builder().add((Object)new DefaultComponentLocation.DefaultLocationPart(componentModelNameAttribute, typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())).build();
            componentLocation = new DefaultComponentLocation(Optional.ofNullable(componentModelNameAttribute), (List)parts);
        } else if (ComponentLocationVisitor.existsWithinRootContainer(hierarchy)) {
            DefaultComponentAstBuilder parentComponentModel = hierarchy.get(hierarchy.size() - 1);
            DefaultComponentLocation parentComponentLocation = (DefaultComponentLocation)parentComponentModel.getLocation();
            Optional<DefaultComponentLocation> locationWithCustomPart = ComponentLocationVisitor.resolveLocationWithCustomPart(componentModel, hierarchy, typedComponentIdentifier, parentComponentLocation);
            componentLocation = locationWithCustomPart.isPresent() ? locationWithCustomPart.get() : ComponentLocationVisitor.resolveNestedLocation(componentModel, hierarchy, typedComponentIdentifier, parentComponentModel, parentComponentLocation);
        } else {
            DefaultComponentAstBuilder parentComponentModel = hierarchy.get(hierarchy.size() - 1);
            DefaultComponentLocation parentComponentLocation = (DefaultComponentLocation)parentComponentModel.getLocation();
            componentLocation = parentComponentLocation.appendLocationPart(ComponentLocationVisitor.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        componentModel.withLocation((ComponentLocation)componentLocation);
    }

    private static DefaultComponentLocation resolveNestedLocation(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy, Optional<TypedComponentIdentifier> typedComponentIdentifier, DefaultComponentAstBuilder parentComponentModel, DefaultComponentLocation parentComponentLocation) {
        if (componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CHAIN)) {
            DefaultComponentLocation.DefaultLocationPart newLastPart = new DefaultComponentLocation.DefaultLocationPart((String)parentComponentModel.getComponentId().orElse(null), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
            return new DefaultComponentLocation(parentComponentModel.getComponentId(), Collections.singletonList(newLastPart));
        }
        if (hierarchy.size() == 1 && ComponentLocationVisitor.isRootProcessorScope(parentComponentModel)) {
            return ComponentLocationVisitor.processFlowDirectChild(componentModel, hierarchy, parentComponentLocation, typedComponentIdentifier);
        }
        if (ComponentLocationVisitor.isErrorHandler(componentModel)) {
            return ComponentLocationVisitor.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier);
        }
        if (ComponentLocationVisitor.isTemplateOnErrorHandler(componentModel)) {
            return ComponentLocationVisitor.processOnErrorModel(componentModel, hierarchy, parentComponentLocation, typedComponentIdentifier);
        }
        if (ComponentLocationVisitor.parentComponentIsRouter(hierarchy)) {
            return ComponentLocationVisitor.processRouterChild(componentModel, hierarchy, typedComponentIdentifier, parentComponentLocation);
        }
        if (ComponentLocationVisitor.isProcessor(componentModel) && !ComponentLocationVisitor.existsWithinSource(hierarchy)) {
            return parentComponentLocation.appendProcessorsPart().appendLocationPart(ComponentLocationVisitor.findProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        if (ComponentLocationVisitor.isConnection(componentModel)) {
            return parentComponentLocation.appendConnectionPart(typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        return parentComponentLocation.appendLocationPart(ComponentLocationVisitor.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private static Optional<DefaultComponentLocation> resolveLocationWithCustomPart(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy, Optional<TypedComponentIdentifier> typedComponentIdentifier, DefaultComponentLocation parentComponentLocation) {
        Optional<Object> locationWithCustomPart = Optional.empty();
        if (customLocationPartModelPropertyClass != null) {
            locationWithCustomPart = componentModel.getModel(EnrichableModel.class).flatMap(em -> em.getModelProperty(customLocationPartModelPropertyClass)).flatMap(customLocationPart -> {
                try {
                    if (((Boolean)customLocationPartModelIsIndexedMethod.invoke(customLocationPart, new Object[0])).booleanValue()) {
                        return Optional.of(parentComponentLocation.appendLocationPart((String)customLocationPartModelGetLocationPartMethod.invoke(customLocationPart, new Object[0]), Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart(ComponentLocationVisitor.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()));
                    }
                    return Optional.of(parentComponentLocation.appendLocationPart((String)customLocationPartModelGetLocationPartMethod.invoke(customLocationPart, new Object[0]), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return Optional.empty();
                }
            });
        }
        return locationWithCustomPart;
    }

    private static boolean isConnection(DefaultComponentAstBuilder componentModel) {
        return componentModel.getModel(ConnectionProviderModel.class).isPresent();
    }

    private static boolean isRoute(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTE);
    }

    private static boolean isRootProcessorScope(DefaultComponentAstBuilder componentModel) {
        return componentModel.getModel(ConstructModel.class).map(ConstructModel::allowsTopLevelDeclaration).orElse(false);
    }

    private static boolean parentComponentIsRouter(List<DefaultComponentAstBuilder> hierarchy) {
        return ComponentLocationVisitor.existsWithinRouter(hierarchy) && ComponentLocationVisitor.isRouter(hierarchy.get(hierarchy.size() - 1));
    }

    private static boolean existsWithinRouter(List<DefaultComponentAstBuilder> hierarchy) {
        return hierarchy.stream().anyMatch(ComponentLocationVisitor::isRouter);
    }

    private static String findNonProcessorPath(DefaultComponentAstBuilder componentModel) {
        return "" + componentModel.getIndexInParent();
    }

    private static String findRoutePath(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy) {
        return String.valueOf(hierarchy.get(hierarchy.size() - 1).childComponentsStream().filter(ComponentLocationVisitor::isRoute).collect(Collectors.toList()).indexOf(componentModel));
    }

    private static DefaultComponentLocation processOnErrorModel(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        int position = hierarchy.get(hierarchy.size() - 1).childComponentsStream().collect(Collectors.toList()).indexOf(componentModel);
        return parentComponentLocation.appendLocationPart(String.valueOf(position), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private static DefaultComponentLocation processRouterChild(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy, Optional<TypedComponentIdentifier> typedComponentIdentifier, DefaultComponentLocation parentComponentLocation) {
        if (ComponentLocationVisitor.isRoute(componentModel)) {
            return parentComponentLocation.appendRoutePart().appendLocationPart(ComponentLocationVisitor.findRoutePath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        if (ComponentLocationVisitor.isProcessor(componentModel)) {
            return parentComponentLocation.appendRoutePart().appendLocationPart(ComponentLocationVisitor.findProcessorPath(componentModel, hierarchy), Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendProcessorsPart().appendLocationPart("0", typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        return parentComponentLocation.appendLocationPart(ComponentLocationVisitor.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private static DefaultComponentLocation processFlowDirectChild(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        DefaultComponentLocation componentLocation = ComponentLocationVisitor.isMessageSource(componentModel) ? parentComponentLocation.appendLocationPart(SOURCE_PART_NAME, typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentLocationVisitor.isProcessor(componentModel) ? parentComponentLocation.appendLocationPart(PROCESSORS_PART_NAME, Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart(ComponentLocationVisitor.findProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentLocationVisitor.isErrorHandler(componentModel) ? ComponentLocationVisitor.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier) : parentComponentLocation.appendLocationPart(ComponentLocationVisitor.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())));
        return componentLocation;
    }

    private static DefaultComponentLocation processErrorHandlerComponent(DefaultComponentAstBuilder componentModel, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        return parentComponentLocation.appendLocationPart("errorHandler", typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private static String findProcessorPath(DefaultComponentAstBuilder componentModel, List<DefaultComponentAstBuilder> hierarchy) {
        return String.valueOf(hierarchy.get(hierarchy.size() - 1).childComponentsStream().filter(ComponentLocationVisitor::isProcessor).collect(Collectors.toList()).indexOf(componentModel));
    }

    private static boolean existsWithinRootContainer(List<DefaultComponentAstBuilder> hierarchy) {
        return hierarchy.stream().anyMatch(p -> p.getModel(ConfigurationModel.class).isPresent() || ComponentLocationVisitor.isRootProcessorScope(p));
    }

    private static boolean existsWithinSource(List<DefaultComponentAstBuilder> hierarchy) {
        return hierarchy.stream().anyMatch(p -> p.getModel(SourceModel.class).isPresent());
    }

    public static boolean isProcessor(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.OPERATION) || componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTER) || componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SCOPE);
    }

    public static boolean isMessageSource(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SOURCE);
    }

    public static boolean isErrorHandler(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
    }

    public static boolean isTemplateOnErrorHandler(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ON_ERROR);
    }

    public static boolean isRouter(DefaultComponentAstBuilder componentModel) {
        return componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTER);
    }

    static {
        Class<?> foundClass = null;
        Method foundIsIndexedMethod = null;
        Method foundGetLocationPartMethod = null;
        try {
            foundClass = Class.forName("org.mule.runtime.module.extension.api.loader.java.property.CustomLocationPartModelProperty");
            foundIsIndexedMethod = foundClass.getMethod("isIndexed", new Class[0]);
            foundGetLocationPartMethod = foundClass.getMethod("getLocationPart", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        customLocationPartModelIsIndexedMethod = foundIsIndexedMethod;
        customLocationPartModelGetLocationPartMethod = foundGetLocationPartMethod;
        customLocationPartModelPropertyClass = foundClass;
    }
}

