/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.internal.xml.DefaultAstXmlParser;
import org.mule.runtime.ast.internal.xml.resolver.FailAfterTenErrorsResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.FailOnFirstErrorResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.w3c.dom.Document;

@NoImplement
public interface AstXmlParser {
    public static final ComponentIdentifier IMPORT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("import").build();
    public static final ComponentIdentifier MULE_ROOT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("mule").build();
    public static final ComponentIdentifier DOMAIN_ROOT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("mule-domain").build();
    public static final ComponentIdentifier ANNOTATIONS_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("annotations").build();

    public static Builder builder() {
        return new Builder();
    }

    public ArtifactAst parseDocument(String var1, List<Pair<String, Document>> var2);

    public ArtifactAst parseDocument(List<Pair<String, Document>> var1);

    public ArtifactAst parse(String var1, List<Pair<String, InputStream>> var2);

    public ArtifactAst parse(List<Pair<String, InputStream>> var1);

    public ArtifactAst parse(String var1, ConfigResource ... var2);

    public ArtifactAst parse(ConfigResource ... var1);

    public ArtifactAst parse(String var1, String var2, InputStream var3);

    public ArtifactAst parse(String var1, InputStream var2);

    public ArtifactAst parse(String var1, URI ... var2);

    public ArtifactAst parse(URI ... var1);

    public ArtifactAst parse(String var1, URL ... var2);

    public ArtifactAst parse(URL ... var1);

    public static final class Builder {
        private static Optional<ExtensionSchemaGenerator> SCHEMA_GENERATOR = StreamSupport.stream(ServiceLoader.load(ExtensionSchemaGenerator.class, ExtensionSchemaGenerator.class.getClassLoader()).spliterator(), false).findFirst();
        private final Set<ExtensionModel> extensionModels = new HashSet<ExtensionModel>();
        private ArtifactType artifactType = ArtifactType.APPLICATION;
        private ArtifactAst parentArtifact;
        private boolean schemaValidations = true;
        private ParsingPropertyResolver propertyResolver = k -> k;
        private ResolveEntityFailStrategy failStrategy = new FailOnFirstErrorResolveEntityFailStrategy();

        public Builder withExtensionModel(ExtensionModel extensionModel) {
            this.extensionModels.add(extensionModel);
            return this;
        }

        public Builder withExtensionModels(Collection<ExtensionModel> extensionModels) {
            this.extensionModels.addAll(extensionModels);
            return this;
        }

        public Builder withArtifactType(ArtifactType artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public Builder withParentArtifact(ArtifactAst parentArtifact) {
            this.parentArtifact = parentArtifact;
            return this;
        }

        public Builder withSchemaValidationsDisabled() {
            this.schemaValidations = false;
            return this;
        }

        public Builder withPropertyResolver(ParsingPropertyResolver propertyResolver) {
            this.propertyResolver = propertyResolver;
            return this;
        }

        public Builder withLegacyFailStrategy() {
            this.failStrategy = new FailAfterTenErrorsResolveEntityFailStrategy();
            return this;
        }

        public AstXmlParser build() {
            return new DefaultAstXmlParser(this.artifactType, this.extensionModels, this.parentArtifact, this.schemaValidations ? SCHEMA_GENERATOR : Optional.empty(), this.propertyResolver, this.failStrategy);
        }
    }
}

