/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFormat;
import org.mule.runtime.ast.internal.serialization.InternalArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstSerializerFormat;

public class ArtifactAstSerializerFactory {
    private final Executor executor;
    private final boolean populateGenerationInformation;
    private final Map<String, JsonArtifactAstSerializerFormat> formats = Collections.singletonMap("JSON", new JsonArtifactAstSerializerFormat());
    private final Map<String, ArtifactAstSerializer> versionToJsonSerializer = new ConcurrentHashMap<String, ArtifactAstSerializer>();
    private final Map<String, InternalArtifactAstDeserializer> versionToJsonDeserializer = new ConcurrentHashMap<String, InternalArtifactAstDeserializer>();

    public ArtifactAstSerializerFactory() {
        this(Executors.newSingleThreadExecutor(), true);
    }

    public ArtifactAstSerializerFactory(Executor executor, boolean populateGenerationInformation) {
        Objects.requireNonNull(executor);
        this.executor = executor;
        this.populateGenerationInformation = populateGenerationInformation;
    }

    public ArtifactAstSerializer getSerializer(String formatId, String serializerVersion) throws IllegalArgumentException {
        Objects.requireNonNull(formatId, "format");
        Objects.requireNonNull(serializerVersion, "serializerVersion");
        ArtifactAstSerializerFormat format = this.formats.get(formatId);
        if (ArtifactAstSerializerFactory.formatIncludesVersion(format, serializerVersion)) {
            return this.versionToJsonSerializer.computeIfAbsent(serializerVersion, version -> format.createSerializer((String)version, this.executor));
        }
        throw new IllegalArgumentException(String.format("No serializer named '%s' version '%s' is available. Available serializers are: [" + StringUtils.join(this.getAvailableSerializers(), (String)", ") + "]", formatId, serializerVersion));
    }

    public InternalArtifactAstDeserializer getDeserializer(String formatId, String serializerVersion) throws IllegalArgumentException {
        Objects.requireNonNull(formatId, "format");
        Objects.requireNonNull(serializerVersion, "serializerVersion");
        ArtifactAstSerializerFormat format = this.formats.get(formatId);
        if (ArtifactAstSerializerFactory.formatIncludesVersion(format, serializerVersion)) {
            return this.versionToJsonDeserializer.computeIfAbsent(serializerVersion, version -> format.createDeserializer((String)version, this.populateGenerationInformation));
        }
        throw new IllegalArgumentException(String.format("No deserializer named '%s' version '%s' is available. Available deserializers are: [" + StringUtils.join(this.getAvailableSerializers(), (String)", ") + "]", formatId, serializerVersion));
    }

    public List<String> getAvailableSerializers() {
        return this.formats.values().stream().flatMap(this::getAvailableSerializersByFormat).collect(Collectors.toList());
    }

    private Stream<String> getAvailableSerializersByFormat(ArtifactAstSerializerFormat format) {
        return format.getAvailableVersions().stream().map(version -> String.format("%s[%s]", format.getId(), version));
    }

    private static boolean formatIncludesVersion(ArtifactAstSerializerFormat format, String serializerVersion) {
        return format != null && format.getAvailableVersions().contains(serializerVersion);
    }
}

