/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.resolver;

import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerationInformationResolver
implements GenerationInformationResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGenerationInformationResolver.class);

    @Override
    public ComponentGenerationInformationDTO resolveComponentAstGenerationInformation(ComponentParameterAstDTO ownerComponentParameterAst, ComponentAstDTO componentAstDTO, ExtensionModelHelper extensionModelHelper) {
        LOGGER.debug("Enrichment: resolveComponentAstGenerationInformation({},{})", (Object)ownerComponentParameterAst, (Object)componentAstDTO);
        return new ComponentGenerationInformationDTO(this.resolveComponentAstSyntax(extensionModelHelper, (NamedObject)(ownerComponentParameterAst != null ? ownerComponentParameterAst.getModel() : (NamedObject)componentAstDTO.getModel(ParameterizedModel.class).orElse(null)), componentAstDTO.getType(), componentAstDTO.getIdentifier(), componentAstDTO.getExtensionModel()));
    }

    @Override
    public ComponentGenerationInformationDTO resolveComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO, ComponentAstDTO ownerComponent, ExtensionModelHelper extensionModelHelper) {
        DslElementSyntax syntax = ownerComponent.getGenerationInformation().getSyntax().flatMap(s -> s.getChild(componentParameterAstDTO.getModel().getName())).orElseGet(() -> extensionModelHelper.resolveDslElementModel(componentParameterAstDTO.getModel(), ownerComponent.getIdentifier()));
        if (!syntax.isWrapped()) {
            return new ComponentGenerationInformationDTO(syntax);
        }
        if (componentParameterAstDTO.isValueAComponentAstDTO()) {
            ComponentAstDTO componentAstDTO = (ComponentAstDTO)((Object)componentParameterAstDTO.getValue().getValue().get());
            return new ComponentGenerationInformationDTO((DslElementSyntax)extensionModelHelper.resolveDslElementModel(componentAstDTO.getType(), componentAstDTO.getIdentifier().getNamespace()).get());
        }
        return new ComponentGenerationInformationDTO(syntax);
    }

    @Override
    public ComponentGenerationInformationDTO resolveRegularComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO, ComponentAstDTO ownerComponent, ExtensionModelHelper extensionModelHelper) {
        DslElementSyntax syntax = ownerComponent.getGenerationInformation().getSyntax().flatMap(s -> s.getContainedElement(componentParameterAstDTO.getModel().getName())).orElseGet(() -> extensionModelHelper.resolveDslElementModel(componentParameterAstDTO.getModel(), ownerComponent.getIdentifier()));
        return new ComponentGenerationInformationDTO(syntax);
    }

    @Override
    public ComponentGenerationInformationDTO resolveWrappedComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO, ComponentAstDTO ownerComponent, ExtensionModelHelper extensionModelHelper) {
        DslElementSyntax syntax = ownerComponent.getGenerationInformation().getSyntax().flatMap(s -> s.getChild(componentParameterAstDTO.getModel().getName())).orElseGet(() -> extensionModelHelper.resolveDslElementModel(componentParameterAstDTO.getModel(), ownerComponent.getIdentifier()));
        if (componentParameterAstDTO.isValueAComponentAstDTO()) {
            ComponentAstDTO componentAstDTO = (ComponentAstDTO)((Object)componentParameterAstDTO.getValue().getValue().get());
            return new ComponentGenerationInformationDTO((DslElementSyntax)extensionModelHelper.resolveDslElementModel(componentAstDTO.getType(), componentAstDTO.getIdentifier().getNamespace()).get());
        }
        return new ComponentGenerationInformationDTO(syntax);
    }

    @Override
    public ComponentGenerationInformationDTO resolveGenerationInformationThroughParent(String parameterName, ComponentAstDTO component, ParameterModel ownerParameterModel, ComponentGenerationInformation ownerParameterGenerationInformation) {
        Optional child = ownerParameterGenerationInformation.getSyntax().flatMap(stx -> stx.getChild(ownerParameterModel.getName()));
        if (!child.isPresent()) {
            return null;
        }
        DslElementSyntax syntax = (DslElementSyntax)child.get();
        Optional<DslElementSyntax> genericSyntax = syntax.getGenerics().values().stream().filter(dslElementSyntax -> dslElementSyntax.getElementName().equals(component.getIdentifier().getName())).findFirst();
        return genericSyntax.map(dslElementSyntax -> new ComponentGenerationInformationDTO((DslElementSyntax)dslElementSyntax.getContainedElement(parameterName).get())).orElse(null);
    }

    @Override
    public ComponentGenerationInformationDTO crateComponentGenerationInformationFromParent(ComponentAstDTO componentAstDTO, ComponentParameterAstDTO componentParameterAstDTO) {
        return new ComponentGenerationInformationDTO(componentAstDTO.getGenerationInformation().getSyntax().flatMap(syntax -> syntax.getChild(componentParameterAstDTO.getModelName())).orElse(componentAstDTO.getGenerationInformation().getSyntax().flatMap(dslElementSyntax -> dslElementSyntax.getContainedElement(componentParameterAstDTO.getModelName())).orElse(null)));
    }

    private DslElementSyntax resolveComponentAstSyntax(ExtensionModelHelper extensionModelHelper, NamedObject model, MetadataType componentAstDtoType, ComponentIdentifier componentAstDtoIdentifier, ExtensionModel extensionModel) {
        if (componentAstDtoType == null) {
            return extensionModelHelper.resolveDslElementModel(model, componentAstDtoIdentifier);
        }
        return extensionModelHelper.resolveDslElementModel(componentAstDtoType, extensionModel).orElseGet(() -> extensionModelHelper.resolveDslElementModel(model, componentAstDtoIdentifier));
    }
}

