/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import java.util.List;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayElementMetadataTypeVisitor
extends MetadataTypeVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayElementMetadataTypeVisitor.class);
    private final ExtensionModelHelper extensionModelHelper;
    private final GenerationInformationResolver generationInformationResolver;
    private final ExtensionModelResolver extensionModelResolver;
    private final ComponentParameterAstDTO ownerComponentParameterAst;
    private final ComponentAstDTO parentComponentAstDTO;

    public ArrayElementMetadataTypeVisitor(ComponentParameterAstDTO componentParameterAstDTO, ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver, ExtensionModelResolver extensionModelResolver) {
        this.extensionModelHelper = extensionModelHelper;
        this.ownerComponentParameterAst = componentParameterAstDTO;
        this.parentComponentAstDTO = parentComponentAstDTO;
        this.generationInformationResolver = generationInformationResolver;
        this.extensionModelResolver = extensionModelResolver;
    }

    public void visitSimpleType(SimpleType simpleType) {
        LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of Simple ComponentAstDTO, parameter {}", (Object)this.ownerComponentParameterAst);
        List componentAstDTOList = (List)this.ownerComponentParameterAst.getValue().getRight();
        componentAstDTOList.forEach(componentAstDTO -> componentAstDTO.resolveSimpleTypeComponentModel(this.ownerComponentParameterAst, simpleType, this.extensionModelResolver, this.extensionModelHelper, this.generationInformationResolver));
    }

    public void visitObject(ObjectType objectType) {
        LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of ComponentAstDTOs, parameter {}", (Object)this.ownerComponentParameterAst);
        List componentAstDTOList = (List)this.ownerComponentParameterAst.getValue().getRight();
        componentAstDTOList.stream().filter(ComponentAstDTO.class::isInstance).forEach(componentAstDTO -> ((ComponentAstDTO)((Object)((Object)componentAstDTO))).resolveModelsRecursively(this.parentComponentAstDTO, this.extensionModelHelper, this.extensionModelResolver, this.generationInformationResolver));
    }
}

